/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime;

import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltStateMachineState;
import org.neo4j.bolt.runtime.StateMachineContext;
import org.neo4j.graphdb.security.AuthorizationExpiredException;

public abstract class FailSafeBoltStateMachineState
implements BoltStateMachineState {
    protected BoltStateMachineState failedState;

    public void setFailedState(BoltStateMachineState failedState) {
        this.failedState = failedState;
    }

    BoltStateMachineState processMessage(StateMachineContext context, SuccessStateSupplier successStateSupplier) throws BoltConnectionFatality {
        try {
            return successStateSupplier.processMessage();
        }
        catch (AuthorizationExpiredException e) {
            context.handleFailure(e, true);
            return this.failedState;
        }
        catch (Throwable t) {
            context.handleFailure(t, false);
            return this.failedState;
        }
    }

    static interface SuccessStateSupplier {
        public BoltStateMachineState processMessage() throws Throwable;
    }
}

