/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime;

import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltStateMachineState;
import org.neo4j.bolt.runtime.StateMachineContext;
import org.neo4j.bolt.runtime.StatementMetadata;
import org.neo4j.bolt.runtime.StatementProcessor;
import org.neo4j.bolt.v1.messaging.request.InterruptSignal;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v3.runtime.FailSafeBoltStateMachineState;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public class ReadyState
extends FailSafeBoltStateMachineState {
    private BoltStateMachineState streamingState;
    private BoltStateMachineState interruptedState;
    private BoltStateMachineState txReadyState;
    static final String FIELDS_KEY = "fields";
    static final String FIRST_RECORD_AVAILABLE_KEY = "result_available_after";
    private static final String TX_ID_KEY = "tx_id";

    @Override
    public BoltStateMachineState process(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        this.assertInitialized();
        if (message instanceof RunMessage) {
            return this.processMessage(context, () -> this.processRunMessage((RunMessage)message, context));
        }
        if (message instanceof BeginMessage) {
            return this.processMessage(context, () -> this.processBeginMessage((BeginMessage)message, context));
        }
        if (message instanceof InterruptSignal) {
            return this.interruptedState;
        }
        return null;
    }

    @Override
    public String name() {
        return "READY";
    }

    public void setStreamingState(BoltStateMachineState streamingState) {
        this.streamingState = streamingState;
    }

    public void setInterruptedState(BoltStateMachineState interruptedState) {
        this.interruptedState = interruptedState;
    }

    public void setTransactionReadyState(BoltStateMachineState txReadyState) {
        this.txReadyState = txReadyState;
    }

    private BoltStateMachineState processRunMessage(RunMessage message, StateMachineContext context) throws KernelException {
        long start = context.clock().millis();
        StatementProcessor statementProcessor = context.connectionState().getStatementProcessor();
        StatementMetadata statementMetadata = statementProcessor.run(message.statement(), message.params(), message.bookmark());
        long end = context.clock().millis();
        context.connectionState().onMetadata(FIELDS_KEY, (AnyValue)Values.stringArray((String[])statementMetadata.fieldNames()));
        context.connectionState().onMetadata(FIRST_RECORD_AVAILABLE_KEY, (AnyValue)Values.longValue((long)(end - start)));
        context.connectionState().onMetadata(TX_ID_KEY, (AnyValue)Values.NO_VALUE);
        return this.streamingState;
    }

    private BoltStateMachineState processBeginMessage(BeginMessage message, StateMachineContext context) throws Exception {
        StatementProcessor statementProcessor = context.connectionState().getStatementProcessor();
        statementProcessor.beginTransaction(message.bookmark());
        context.connectionState().onMetadata(TX_ID_KEY, (AnyValue)Values.NO_VALUE);
        return this.txReadyState;
    }

    private void assertInitialized() {
        Preconditions.checkState((this.streamingState != null ? 1 : 0) != 0, (String)"Streaming state not set");
        Preconditions.checkState((this.interruptedState != null ? 1 : 0) != 0, (String)"Interrupted state not set");
        Preconditions.checkState((this.failedState != null ? 1 : 0) != 0, (String)"Failed state not set");
        Preconditions.checkState((this.txReadyState != null ? 1 : 0) != 0, (String)"TransactionReady state not set");
    }
}

