/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime;

import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltStateMachineState;
import org.neo4j.bolt.runtime.StateMachineContext;
import org.neo4j.bolt.runtime.StatementMetadata;
import org.neo4j.bolt.runtime.StatementProcessor;
import org.neo4j.bolt.v1.messaging.request.InterruptSignal;
import org.neo4j.bolt.v1.runtime.bookmarking.Bookmark;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v3.runtime.FailSafeBoltStateMachineState;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public class TransactionReadyState
extends FailSafeBoltStateMachineState {
    private BoltStateMachineState streamingState;
    private BoltStateMachineState interruptedState;
    private BoltStateMachineState readyState;

    @Override
    public BoltStateMachineState process(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        this.assertInitialized();
        if (message instanceof RunMessage) {
            return this.processMessage(context, () -> this.processRunMessage((RunMessage)message, context));
        }
        if (message instanceof CommitMessage) {
            return this.processMessage(context, () -> this.processCommitMessage(context));
        }
        if (message instanceof RollbackMessage) {
            return this.processMessage(context, () -> this.processRollbackMessage(context));
        }
        if (message instanceof InterruptSignal) {
            return this.interruptedState;
        }
        return null;
    }

    @Override
    public String name() {
        return "TX_READY";
    }

    public void setTransactionStreamingState(BoltStateMachineState streamingState) {
        this.streamingState = streamingState;
    }

    public void setInterruptedState(BoltStateMachineState interruptedState) {
        this.interruptedState = interruptedState;
    }

    public void setReadyState(BoltStateMachineState readyState) {
        this.readyState = readyState;
    }

    private BoltStateMachineState processRunMessage(RunMessage message, StateMachineContext context) throws KernelException {
        long start = context.clock().millis();
        StatementProcessor statementProcessor = context.connectionState().getStatementProcessor();
        StatementMetadata statementMetadata = statementProcessor.run(message.statement(), message.params());
        long end = context.clock().millis();
        context.connectionState().onMetadata("fields", (AnyValue)Values.stringArray((String[])statementMetadata.fieldNames()));
        context.connectionState().onMetadata("result_available_after", (AnyValue)Values.longValue((long)(end - start)));
        return this.streamingState;
    }

    private BoltStateMachineState processCommitMessage(StateMachineContext context) throws Exception {
        StatementProcessor statementProcessor = context.connectionState().getStatementProcessor();
        Bookmark bookmark = statementProcessor.commitTransaction();
        bookmark.attachTo(context.connectionState());
        return this.readyState;
    }

    private BoltStateMachineState processRollbackMessage(StateMachineContext context) throws Exception {
        StatementProcessor statementProcessor = context.connectionState().getStatementProcessor();
        statementProcessor.rollbackTransaction();
        return this.readyState;
    }

    private void assertInitialized() {
        Preconditions.checkState((this.streamingState != null ? 1 : 0) != 0, (String)"Streaming state not set");
        Preconditions.checkState((this.interruptedState != null ? 1 : 0) != 0, (String)"Interrupted state not set");
        Preconditions.checkState((this.readyState != null ? 1 : 0) != 0, (String)"Ready state not set");
        Preconditions.checkState((this.failedState != null ? 1 : 0) != 0, (String)"Failed state not set");
    }
}

