/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.messaging;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.messaging.RequestMessageDecoder;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.packstream.PackStream;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.Neo4jError;
import org.neo4j.kernel.api.exceptions.Status;

public abstract class BoltRequestMessageReader {
    private final BoltConnection connection;
    private final BoltResponseHandler externalErrorResponseHandler;
    private final Map<Integer, RequestMessageDecoder> decoders;

    protected BoltRequestMessageReader(BoltConnection connection, BoltResponseHandler externalErrorResponseHandler, List<RequestMessageDecoder> decoders) {
        this.connection = connection;
        this.externalErrorResponseHandler = externalErrorResponseHandler;
        this.decoders = decoders.stream().collect(Collectors.toMap(RequestMessageDecoder::signature, Function.identity()));
    }

    public void read(Neo4jPack.Unpacker unpacker) throws IOException {
        try {
            this.doRead(unpacker);
        }
        catch (BoltIOException e) {
            if (e.causesFailureMessage()) {
                Neo4jError error = Neo4jError.from(e);
                this.connection.enqueue(stateMachine -> stateMachine.handleExternalFailure(error, this.externalErrorResponseHandler));
            }
            throw e;
        }
    }

    private void doRead(Neo4jPack.Unpacker unpacker) throws IOException {
        try {
            unpacker.unpackStructHeader();
            char signature = unpacker.unpackStructSignature();
            RequestMessageDecoder decoder = this.decoders.get(signature);
            if (decoder == null) {
                throw new BoltIOException((Status)Status.Request.InvalidFormat, String.format("Message 0x%s is not a valid message signature.", Integer.toHexString(signature)));
            }
            RequestMessage message = decoder.decode(unpacker);
            BoltResponseHandler responseHandler = decoder.responseHandler();
            this.connection.enqueue(stateMachine -> stateMachine.process(message, responseHandler));
        }
        catch (PackStream.PackStreamException e) {
            throw new BoltIOException((Status)Status.Request.InvalidFormat, String.format("Unable to read message type. Error was: %s.", e.getMessage()), e);
        }
    }
}

