/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime.statemachine.impl;

import java.time.Clock;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachine;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineFactory;
import org.neo4j.bolt.runtime.statemachine.impl.BoltStateMachineSPIImpl;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.v3.BoltStateMachineV3;
import org.neo4j.bolt.v3.runtime.TransactionStateMachineSPIProviderV3;
import org.neo4j.bolt.v4.BoltStateMachineV4;
import org.neo4j.bolt.v4.runtime.TransactionStateMachineSPIProviderV4;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.logging.internal.LogService;
import org.neo4j.time.SystemNanoClock;

public class BoltStateMachineFactoryImpl
implements BoltStateMachineFactory {
    private final BoltGraphDatabaseManagementServiceSPI boltGraphDatabaseManagementServiceSPI;
    private final LogService logging;
    private final Authentication authentication;
    private final Config config;
    private final SystemNanoClock clock;
    private final String defaultDatabaseName;

    public BoltStateMachineFactoryImpl(BoltGraphDatabaseManagementServiceSPI boltGraphDatabaseManagementServiceSPI, Authentication authentication, SystemNanoClock clock, Config config, LogService logging) {
        this.boltGraphDatabaseManagementServiceSPI = boltGraphDatabaseManagementServiceSPI;
        this.logging = logging;
        this.authentication = authentication;
        this.config = config;
        this.clock = clock;
        this.defaultDatabaseName = (String)config.get(GraphDatabaseSettings.default_database);
    }

    @Override
    public BoltStateMachine newStateMachine(long protocolVersion, BoltChannel boltChannel) {
        if (protocolVersion == 3L) {
            return this.newStateMachineV3(boltChannel);
        }
        if (protocolVersion == 4L) {
            return this.newStateMachineV4(boltChannel);
        }
        throw new IllegalArgumentException("Failed to create a state machine for protocol version " + protocolVersion);
    }

    private BoltStateMachine newStateMachineV3(BoltChannel boltChannel) {
        TransactionStateMachineSPIProviderV3 transactionSpiProvider = new TransactionStateMachineSPIProviderV3(this.boltGraphDatabaseManagementServiceSPI, this.defaultDatabaseName, boltChannel, this.clock);
        BoltStateMachineSPIImpl boltSPI = new BoltStateMachineSPIImpl(this.logging, this.authentication, transactionSpiProvider);
        return new BoltStateMachineV3(boltSPI, boltChannel, (Clock)this.clock);
    }

    private BoltStateMachine newStateMachineV4(BoltChannel boltChannel) {
        TransactionStateMachineSPIProviderV4 transactionSpiProvider = new TransactionStateMachineSPIProviderV4(this.boltGraphDatabaseManagementServiceSPI, this.defaultDatabaseName, boltChannel, this.clock);
        BoltStateMachineSPIImpl boltSPI = new BoltStateMachineSPIImpl(this.logging, this.authentication, transactionSpiProvider);
        return new BoltStateMachineV4(boltSPI, boltChannel, (Clock)this.clock);
    }
}

