/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.neo4j.bolt.BoltServer;
import org.neo4j.bolt.transport.configuration.EpollConfigurationProvider;
import org.neo4j.bolt.transport.configuration.NioConfigurationProvider;
import org.neo4j.bolt.transport.configuration.ServerConfigurationProvider;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.helpers.PortBindException;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.function.ThrowingAction;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.util.FeatureToggles;

public class NettyServer
extends LifecycleAdapter {
    private static final boolean USE_EPOLL = FeatureToggles.flag(NettyServer.class, (String)"useEpoll", (boolean)true);
    private static final int SHUTDOWN_QUIET_PERIOD = FeatureToggles.getInteger(NettyServer.class, (String)"shutdownQuietPeriod", (int)5);
    private static final int SHUTDOWN_TIMEOUT = FeatureToggles.getInteger(NettyServer.class, (String)"shutdownTimeout", (int)15);
    private final ServerConfigurationProvider configurationProvider;
    private final ProtocolInitializer initializer;
    private final ThreadFactory tf;
    private final ConnectorPortRegister portRegister;
    private final Log userLog;
    private final Log internalLog;
    private EventLoopGroup eventLoopGroup;
    private List<Channel> serverChannels;

    public NettyServer(ThreadFactory tf, ProtocolInitializer initializer, ConnectorPortRegister connectorRegister, LogService logService) {
        this.initializer = initializer;
        this.tf = tf;
        this.portRegister = connectorRegister;
        this.userLog = logService.getUserLog(BoltServer.class);
        this.internalLog = logService.getUserLog(((Object)((Object)this)).getClass());
        this.configurationProvider = NettyServer.createConfigurationProvider();
        this.serverChannels = new ArrayList<Channel>();
    }

    public void init() throws Exception {
        this.eventLoopGroup = this.configurationProvider.createEventLoopGroup(this.tf);
    }

    public void start() throws Exception {
        if (this.initializer != null) {
            try {
                Channel channel = this.bind(this.configurationProvider, this.initializer);
                this.serverChannels.add(channel);
                InetSocketAddress localAddress = (InetSocketAddress)channel.localAddress();
                this.portRegister.register("bolt", localAddress);
                String host = this.initializer.address().getHostname();
                int port = localAddress.getPort();
                this.userLog.info("Bolt enabled on %s.", new Object[]{SocketAddress.format((String)host, (int)port)});
            }
            catch (Throwable e) {
                throw new PortBindException(this.initializer.address(), e);
            }
        }
    }

    public void stop() throws Exception {
        ThrowingAction.executeAll((ThrowingAction[])new ThrowingAction[]{this::unregisterListenAddresses, this::closeChannels});
    }

    public void shutdown() throws Exception {
        this.shutdownEventLoopGroup();
    }

    private Channel bind(ServerConfigurationProvider configurationProvider, ProtocolInitializer protocolInitializer) throws InterruptedException {
        ServerBootstrap serverBootstrap = this.createServerBootstrap(configurationProvider, protocolInitializer);
        InetSocketAddress address = protocolInitializer.address().socketAddress();
        return serverBootstrap.bind((java.net.SocketAddress)address).sync().channel();
    }

    private ServerBootstrap createServerBootstrap(ServerConfigurationProvider configurationProvider, ProtocolInitializer protocolInitializer) {
        return ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.eventLoopGroup).channel(configurationProvider.getChannelClass())).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler(protocolInitializer.channelInitializer());
    }

    private static ServerConfigurationProvider createConfigurationProvider() {
        boolean useEpoll = USE_EPOLL && Epoll.isAvailable();
        return useEpoll ? EpollConfigurationProvider.INSTANCE : NioConfigurationProvider.INSTANCE;
    }

    private void unregisterListenAddresses() {
        this.portRegister.deregister("bolt");
    }

    private void closeChannels() {
        this.internalLog.debug("Closing server channels");
        for (Channel channel : this.serverChannels) {
            try {
                channel.close().syncUninterruptibly();
            }
            catch (Throwable t) {
                this.internalLog.warn("Failed to close channel " + channel, t);
            }
        }
        this.internalLog.debug("Server channels closed");
        this.serverChannels.clear();
    }

    private void shutdownEventLoopGroup() {
        if (this.eventLoopGroup != null) {
            try {
                this.internalLog.debug("Shutting down event loop group");
                this.eventLoopGroup.shutdownGracefully((long)SHUTDOWN_QUIET_PERIOD, (long)SHUTDOWN_TIMEOUT, TimeUnit.SECONDS).syncUninterruptibly();
                this.internalLog.debug("Event loop group shut down");
            }
            catch (Throwable t) {
                this.internalLog.warn("Failed to shutdown event loop group", t);
            }
            this.eventLoopGroup = null;
        }
    }

    public static interface ProtocolInitializer {
        public ChannelInitializer<Channel> channelInitializer();

        public SocketAddress address();
    }
}

