/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.txtracking;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.neo4j.bolt.txtracking.ReconciledTransactionTracker;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.util.Preconditions;
import org.neo4j.util.concurrent.ArrayQueueOutOfOrderSequence;
import org.neo4j.util.concurrent.OutOfOrderSequence;

public class DefaultReconciledTransactionTracker
implements ReconciledTransactionTracker {
    private static final int INITIAL_ARRAY_SIZE = 200;
    private static final long[] NO_METADATA = new long[0];
    private final ReadWriteLock initializationLock = new ReentrantReadWriteLock();
    private final Log log;
    private long startingNumber;
    private OutOfOrderSequence sequence;

    public DefaultReconciledTransactionTracker(LogService logService) {
        this.log = logService.getInternalLog(this.getClass());
    }

    @Override
    public void initialize(long reconciledTransactionId) {
        Preconditions.requireNonNegative((long)reconciledTransactionId);
        this.initializationLock.writeLock().lock();
        try {
            if (this.sequence == null) {
                this.log.info("Initializing with transaction ID %s", new Object[]{reconciledTransactionId});
            } else {
                this.log.info("Re-initializing from %s to transaction ID %s", new Object[]{this.sequence, reconciledTransactionId});
            }
            this.sequence = new ArrayQueueOutOfOrderSequence(reconciledTransactionId, 200, NO_METADATA);
            this.startingNumber = reconciledTransactionId;
        }
        finally {
            this.initializationLock.writeLock().unlock();
        }
    }

    @Override
    public long getLastReconciledTransactionId() {
        this.initializationLock.readLock().lock();
        try {
            long l = this.sequence != null ? this.sequence.getHighestGapFreeNumber() : -1L;
            return l;
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastReconciledTransactionId(long reconciledTransactionId) {
        Preconditions.requireNonNegative((long)reconciledTransactionId);
        this.initializationLock.readLock().lock();
        try {
            Preconditions.checkState((this.sequence != null ? 1 : 0) != 0, (String)"Not initialized");
            if (reconciledTransactionId < this.startingNumber) {
                this.log.info("Ignoring pre-initialization ID  %s", new Object[]{reconciledTransactionId});
                return;
            }
            long currentLastReconciledTxId = this.getLastReconciledTransactionId();
            Preconditions.checkArgument((reconciledTransactionId > currentLastReconciledTxId ? 1 : 0) != 0, (String)"Received illegal transaction ID %s which is lower than the current transaction ID %s. Sequence: %s", (Object[])new Object[]{reconciledTransactionId, currentLastReconciledTxId, this.sequence});
            this.log.debug("Updating %s with transaction ID %s", new Object[]{this.sequence, reconciledTransactionId});
            this.sequence.offer(reconciledTransactionId, NO_METADATA);
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
    }
}

