/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging.encoder;

import java.io.IOException;
import org.neo4j.bolt.messaging.ResponseMessageEncoder;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.v3.messaging.response.FailureMessage;
import org.neo4j.bolt.v3.messaging.response.FatalFailureMessage;
import org.neo4j.logging.Log;

public class FailureMessageEncoder
implements ResponseMessageEncoder<FailureMessage> {
    private final Log log;

    public FailureMessageEncoder(Log log) {
        this.log = log;
    }

    @Override
    public void encode(Neo4jPack.Packer packer, FailureMessage message) throws IOException {
        if (message instanceof FatalFailureMessage) {
            this.log.debug("Encoding a fatal failure message to send. Message: %s", new Object[]{message});
        }
        this.encodeFailure(message, packer);
    }

    private void encodeFailure(FailureMessage message, Neo4jPack.Packer packer) throws IOException {
        packer.packStructHeader(1, message.signature());
        packer.packMapHeader(2);
        packer.pack("code");
        packer.pack(message.status().code().serialize());
        packer.pack("message");
        packer.pack(message.message());
    }
}

