/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime.bookmarking;

import java.util.Objects;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.Bookmark;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public class BookmarkWithPrefix
implements Bookmark {
    static final String BOOKMARK_TX_PREFIX = "neo4j:bookmark:v1:tx";
    private final long txId;

    public BookmarkWithPrefix(long txId) {
        this.txId = txId;
    }

    @Override
    public long txId() {
        return this.txId;
    }

    @Override
    public NamedDatabaseId databaseId() {
        return null;
    }

    @Override
    public void attachTo(BoltResponseHandler state) {
        state.onMetadata("bookmark", (AnyValue)Values.stringValue((String)this.toString()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookmarkWithPrefix bookmark = (BookmarkWithPrefix)o;
        return this.txId == bookmark.txId;
    }

    public int hashCode() {
        return Objects.hash(this.txId);
    }

    public String toString() {
        return String.format("neo4j:bookmark:v1:tx%d", this.txId);
    }
}

