/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime.bookmarking;

import java.util.Objects;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.Bookmark;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public class BookmarkWithDatabaseId
implements Bookmark {
    private final long txId;
    private final NamedDatabaseId namedDatabaseId;

    public BookmarkWithDatabaseId(long txId, NamedDatabaseId namedDatabaseId) {
        this.txId = txId;
        this.namedDatabaseId = namedDatabaseId;
    }

    @Override
    public long txId() {
        return this.txId;
    }

    @Override
    public NamedDatabaseId databaseId() {
        return this.namedDatabaseId;
    }

    @Override
    public void attachTo(BoltResponseHandler state) {
        state.onMetadata("bookmark", (AnyValue)Values.stringValue((String)this.toString()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookmarkWithDatabaseId that = (BookmarkWithDatabaseId)o;
        return this.txId == that.txId && Objects.equals(this.namedDatabaseId, that.namedDatabaseId);
    }

    public int hashCode() {
        return Objects.hash(this.txId, this.namedDatabaseId);
    }

    public String toString() {
        return String.format("%s:%d", this.namedDatabaseId.databaseId().uuid(), this.txId);
    }
}

