/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.channel.Channel;
import java.time.Clock;
import java.time.Duration;
import org.neo4j.bolt.transport.TransportThrottle;
import org.neo4j.bolt.transport.TransportWriteThrottle;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;

public class TransportThrottleGroup {
    public static final TransportThrottleGroup NO_THROTTLE = new TransportThrottleGroup();
    private final TransportThrottle writeThrottle;

    private TransportThrottleGroup() {
        this.writeThrottle = NoOpTransportThrottle.INSTANCE;
    }

    public TransportThrottleGroup(Config config, Clock clock) {
        this.writeThrottle = TransportThrottleGroup.createWriteThrottle(config, clock);
    }

    public TransportThrottle writeThrottle() {
        return this.writeThrottle;
    }

    public void install(Channel channel) {
        this.writeThrottle.install(channel);
    }

    public void uninstall(Channel channel) {
        this.writeThrottle.uninstall(channel);
    }

    private static TransportThrottle createWriteThrottle(Config config, Clock clock) {
        if (((Boolean)config.get(GraphDatabaseInternalSettings.bolt_outbound_buffer_throttle)).booleanValue()) {
            return new TransportWriteThrottle((Integer)config.get(GraphDatabaseInternalSettings.bolt_outbound_buffer_throttle_low_water_mark), (Integer)config.get(GraphDatabaseInternalSettings.bolt_outbound_buffer_throttle_high_water_mark), clock, (Duration)config.get(GraphDatabaseInternalSettings.bolt_outbound_buffer_throttle_max_duration));
        }
        return NoOpTransportThrottle.INSTANCE;
    }

    private static class NoOpTransportThrottle
    implements TransportThrottle {
        private static final TransportThrottle INSTANCE = new NoOpTransportThrottle();

        private NoOpTransportThrottle() {
        }

        @Override
        public void install(Channel channel) {
        }

        @Override
        public void acquire(Channel channel) {
        }

        @Override
        public void release(Channel channel) {
        }

        @Override
        public void uninstall(Channel channel) {
        }
    }
}

