/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.CombiningIterable;
import org.neo4j.helpers.collection.FilterIterable;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapIterable;
import org.neo4j.helpers.collection.Pair;

public final class Iterables {
    private static final ResourceIterable EMPTY_RESOURCE_ITERATOR = new EmptyResourceIterable();

    private Iterables() {
    }

    public static <T> Iterable<T> empty() {
        return Collections.emptyList();
    }

    public static <T> Iterable<T> emptyResourceIterable() {
        return EMPTY_RESOURCE_ITERATOR;
    }

    public static <T> Iterable<T> limit(final int limitItems, Iterable<T> iterable) {
        return () -> {
            final Iterator iterator = iterable.iterator();
            return new Iterator<T>(){
                int count;

                @Override
                public boolean hasNext() {
                    return this.count < limitItems && iterator.hasNext();
                }

                @Override
                public T next() {
                    ++this.count;
                    return iterator.next();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        };
    }

    public static <T> Function<Iterable<T>, Iterable<T>> limit(int limitItems) {
        return ts -> Iterables.limit(limitItems, ts);
    }

    public static <T> Iterable<T> unique(Iterable<T> iterable) {
        return () -> {
            final Iterator iterator = iterable.iterator();
            return new Iterator<T>(){
                Set items = new HashSet();
                Object nextItem;

                @Override
                public boolean hasNext() {
                    while (iterator.hasNext()) {
                        this.nextItem = iterator.next();
                        if (!this.items.add(this.nextItem)) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public T next() {
                    if (this.nextItem == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.nextItem;
                }

                @Override
                public void remove() {
                }
            };
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, C extends Collection<T>> C addAll(C collection, Iterable<? extends T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        try {
            while (iterator.hasNext()) {
                collection.add(iterator.next());
            }
        }
        finally {
            if (iterator instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)iterator)).close();
                }
                catch (Exception exception) {}
            }
        }
        return collection;
    }

    public static <X> Iterable<X> filter(Predicate<? super X> specification, Iterable<X> i) {
        return new FilterIterable<X>(i, specification);
    }

    public static <X> Iterable<X> skip(int skip, Iterable<X> iterable) {
        return () -> {
            Iterator iterator = iterable.iterator();
            for (int i = 0; i < skip; ++i) {
                if (!iterator.hasNext()) {
                    return Collections.emptyIterator();
                }
                iterator.next();
            }
            return iterator;
        };
    }

    public static <X> Iterable<X> reverse(Iterable<X> iterable) {
        List<X> list = Iterables.asList(iterable);
        Collections.reverse(list);
        return list;
    }

    @SafeVarargs
    public static <X, I extends Iterable<? extends X>> Iterable<X> flatten(I ... multiIterator) {
        return new FlattenIterable(Arrays.asList(multiIterator));
    }

    public static <X, S extends Iterable<? extends X>, I extends Iterable<S>> Iterable<X> flattenIterable(I multiIterator) {
        return new FlattenIterable(multiIterator);
    }

    @SafeVarargs
    public static <T> Iterable<T> mix(Iterable<T> ... iterables) {
        return () -> {
            final List<Iterator> iterators = Iterables.asList(Iterables.map(Iterable::iterator, Arrays.asList(iterables)));
            return new Iterator<T>(){
                Iterator iterator;
                Iterator iter;

                @Override
                public boolean hasNext() {
                    for (Iterator iterator : iterators) {
                        if (!iterator.hasNext()) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public T next() {
                    if (this.iterator == null) {
                        this.iterator = iterators.iterator();
                    }
                    while (this.iterator.hasNext()) {
                        this.iter = (Iterator)this.iterator.next();
                        if (!this.iter.hasNext()) continue;
                        return this.iter.next();
                    }
                    this.iterator = null;
                    return this.next();
                }

                @Override
                public void remove() {
                    if (this.iter != null) {
                        this.iter.remove();
                    }
                }
            };
        };
    }

    public static <FROM, TO> Iterable<TO> map(Function<? super FROM, ? extends TO> function, Iterable<FROM> from) {
        return new MapIterable<FROM, TO>(from, function);
    }

    public static <FROM, TO> Iterable<TO> flatMap(Function<? super FROM, ? extends Iterable<TO>> function, Iterable<FROM> from) {
        return new CombiningIterable(Iterables.map(function, from));
    }

    @SafeVarargs
    public static <T, C extends T> Iterable<T> iterable(C ... items) {
        return Arrays.asList(items);
    }

    public static <T, C> Iterable<T> cast(Iterable<C> iterable) {
        return iterable;
    }

    @SafeVarargs
    public static <T> Iterable<T> concat(Iterable<? extends T> ... iterables) {
        return Iterables.concat(Arrays.asList(iterables));
    }

    public static <T> Iterable<T> concat(Iterable<Iterable<T>> iterables) {
        return new CombiningIterable<T>(iterables);
    }

    public static <T, C extends T> Iterable<T> prepend(final C item, final Iterable<T> iterable) {
        return () -> new Iterator<T>(){
            Object first;
            Iterator iterator;
            {
                this.first = item;
            }

            @Override
            public boolean hasNext() {
                if (this.first != null) {
                    return true;
                }
                if (this.iterator == null) {
                    this.iterator = iterable.iterator();
                }
                return this.iterator.hasNext();
            }

            @Override
            public T next() {
                if (this.first != null) {
                    try {
                        Object object = this.first;
                        return object;
                    }
                    finally {
                        this.first = null;
                    }
                }
                return this.iterator.next();
            }

            @Override
            public void remove() {
            }
        };
    }

    public static <T, C extends T> Iterable<T> append(final C item, Iterable<T> iterable) {
        return () -> {
            final Iterator iterator = iterable.iterator();
            return new Iterator<T>(){
                Object last;
                {
                    this.last = item;
                }

                @Override
                public boolean hasNext() {
                    return iterator.hasNext() || this.last != null;
                }

                @Override
                public T next() {
                    if (iterator.hasNext()) {
                        return iterator.next();
                    }
                    try {
                        Object object = this.last;
                        return object;
                    }
                    finally {
                        this.last = null;
                    }
                }

                @Override
                public void remove() {
                }
            };
        };
    }

    public static <T> Iterable<T> cache(Iterable<T> iterable) {
        return new CacheIterable(iterable);
    }

    public static Object[] asArray(Iterable<Object> iterable) {
        return Iterables.asArray(Object.class, iterable);
    }

    public static <T> T[] asArray(Class<T> componentType, Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        List<Object> list = Iterables.asList(iterable);
        return list.toArray((Object[])Array.newInstance(componentType, list.size()));
    }

    public static <T> ResourceIterable<T> asResourceIterable(Iterable<T> iterable) {
        if (iterable instanceof ResourceIterable) {
            return (ResourceIterable)iterable;
        }
        return () -> Iterators.asResourceIterator(iterable.iterator());
    }

    public static String toString(Iterable<?> values, String separator) {
        Iterator<?> it = values.iterator();
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            sb.append(it.next().toString());
            if (!it.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static <T> T firstOrNull(Iterable<T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        try {
            T t = Iterators.firstOrNull(iterator);
            return t;
        }
        finally {
            if (iterator instanceof Resource) {
                ((Resource)iterator).close();
            }
        }
    }

    public static <T> T first(Iterable<T> iterable) {
        return Iterators.first(iterable.iterator());
    }

    public static <T> T lastOrNull(Iterable<T> iterable) {
        return Iterators.lastOrNull(iterable.iterator());
    }

    public static <T> T last(Iterable<T> iterable) {
        return Iterators.last(iterable.iterator());
    }

    public static <T> T singleOrNull(Iterable<T> iterable) {
        return Iterators.singleOrNull(iterable.iterator());
    }

    public static <T> T single(Iterable<T> iterable) {
        return Iterators.single(iterable.iterator());
    }

    public static <T> T single(Iterable<T> iterable, T itemIfNone) {
        return Iterators.single(iterable.iterator(), itemIfNone);
    }

    public static <T> T fromEnd(Iterable<T> iterable, int n) {
        return Iterators.fromEnd(iterable.iterator(), n);
    }

    public static <C extends Collection<T>, T> C addToCollection(Iterable<T> iterable, C collection) {
        return Iterators.addToCollection(iterable.iterator(), collection);
    }

    public static <T> long count(Iterable<T> iterable) {
        return Iterables.count(iterable, Predicates.alwaysTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> long count(Iterable<T> iterable, Predicate<T> filter) {
        Iterator<T> iterator = iterable.iterator();
        try {
            long l = Iterators.count(iterator, filter);
            return l;
        }
        finally {
            if (iterator instanceof ResourceIterator) {
                ((ResourceIterator)iterator).close();
            }
        }
    }

    public static <T> Collection<T> asCollection(Iterable<T> iterable) {
        return Iterables.addToCollection(iterable, new ArrayList());
    }

    public static <T> List<T> asList(Iterable<T> iterator) {
        return Iterables.addToCollection(iterator, new ArrayList());
    }

    public static <T, U> Map<T, U> asMap(Iterable<Pair<T, U>> pairs) {
        HashMap<T, U> map = new HashMap<T, U>();
        for (Pair<T, U> pair : pairs) {
            map.put(pair.first(), pair.other());
        }
        return map;
    }

    public static <T> Set<T> asSet(Iterable<T> iterable) {
        return Iterables.addToCollection(iterable, new HashSet());
    }

    public static <T> Set<T> asUniqueSet(Iterable<T> iterable) {
        return Iterators.addToCollectionUnique(iterable, new HashSet());
    }

    public static Iterable<Long> asIterable(long ... array) {
        return () -> Iterators.asIterator(array);
    }

    public static Iterable<Integer> asIterable(int ... array) {
        return () -> Iterators.asIterator(array);
    }

    @SafeVarargs
    public static <T> Iterable<T> asIterable(T ... array) {
        return () -> Iterators.iterator(array);
    }

    public static <T> ResourceIterable<T> resourceIterable(Iterable<T> iterable) {
        return () -> Iterators.resourceIterator(iterable.iterator(), Resource.EMPTY);
    }

    public static <T> int indexOf(T itemToFind, Iterable<T> iterable) {
        if (itemToFind == null) {
            int index = 0;
            for (T item : iterable) {
                if (item == null) {
                    return index;
                }
                ++index;
            }
        } else {
            int index = 0;
            for (T item : iterable) {
                if (itemToFind.equals(item)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public static <T> Iterable<T> option(T item) {
        if (item == null) {
            return Collections.emptyList();
        }
        return () -> Iterators.iterator(item);
    }

    public static <T, S extends Comparable> Iterable<T> sort(Iterable<T> iterable, Function<T, S> compareFunction) {
        List<T> list = Iterables.asList(iterable);
        Collections.sort(list, (o1, o2) -> ((Comparable)compareFunction.apply(o1)).compareTo(compareFunction.apply(o2)));
        return list;
    }

    public static String join(String joinString, Iterable<?> iter) {
        return Iterators.join(joinString, iter.iterator());
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return Iterables.stream(iterable, 0);
    }

    public static <T> Stream<T> stream(Iterable<T> iterable, int characteristics) {
        Objects.requireNonNull(iterable);
        return Iterators.stream(iterable.iterator(), characteristics);
    }

    public static <T extends Enum<T>> List<String> enumNames(Class<T> cls) {
        ArrayList<String> names = new ArrayList<String>();
        EnumSet.allOf(cls).forEach(item -> names.add(item.name()));
        return names;
    }

    private static class EmptyResourceIterable<T>
    implements ResourceIterable<T> {
        private EmptyResourceIterable() {
        }

        public ResourceIterator<T> iterator() {
            return Iterators.emptyResourceIterator();
        }
    }

    private static class CacheIterable<T>
    implements Iterable<T> {
        private final Iterable<T> iterable;
        private Iterable<T> cache;

        private CacheIterable(Iterable<T> iterable) {
            this.iterable = iterable;
        }

        @Override
        public Iterator<T> iterator() {
            if (this.cache != null) {
                return this.cache.iterator();
            }
            final Iterator<T> source = this.iterable.iterator();
            return new Iterator<T>(){
                List<T> iteratorCache = new ArrayList();

                @Override
                public boolean hasNext() {
                    boolean hasNext = source.hasNext();
                    if (!hasNext) {
                        cache = this.iteratorCache;
                    }
                    return hasNext;
                }

                @Override
                public T next() {
                    Object next = source.next();
                    this.iteratorCache.add(next);
                    return next;
                }

                @Override
                public void remove() {
                }
            };
        }
    }

    private static class FlattenIterable<T, I extends Iterable<? extends T>>
    implements Iterable<T> {
        private final Iterable<I> iterable;

        FlattenIterable(Iterable<I> iterable) {
            this.iterable = iterable;
        }

        @Override
        public Iterator<T> iterator() {
            return new FlattenIterator(this.iterable.iterator());
        }

        static class FlattenIterator<T, I extends Iterable<? extends T>>
        implements Iterator<T> {
            private final Iterator<I> iterator;
            private Iterator<? extends T> currentIterator;

            FlattenIterator(Iterator<I> iterator) {
                this.iterator = iterator;
                this.currentIterator = null;
            }

            @Override
            public boolean hasNext() {
                if (this.currentIterator == null) {
                    if (this.iterator.hasNext()) {
                        Iterable next = (Iterable)this.iterator.next();
                        this.currentIterator = next.iterator();
                    } else {
                        return false;
                    }
                }
                while (!this.currentIterator.hasNext() && this.iterator.hasNext()) {
                    this.currentIterator = ((Iterable)this.iterator.next()).iterator();
                }
                return this.currentIterator.hasNext();
            }

            @Override
            public T next() {
                return this.currentIterator.next();
            }

            @Override
            public void remove() {
                if (this.currentIterator == null) {
                    throw new IllegalStateException();
                }
                this.currentIterator.remove();
            }
        }
    }
}

