/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;

public abstract class ResourceClosingIterator<T, V>
implements ResourceIterator<V> {
    private Resource resource;
    private final Iterator<T> iterator;

    public static <R> ResourceIterator<R> newResourceIterator(Resource resource, Iterator<R> iterator) {
        return new ResourceClosingIterator<R, R>(resource, iterator){

            @Override
            public R map(R elem) {
                return elem;
            }
        };
    }

    ResourceClosingIterator(Resource resource, Iterator<T> iterator) {
        this.resource = resource;
        this.iterator = iterator;
    }

    public void close() {
        this.resource.close();
        this.resource = Resource.EMPTY;
    }

    public boolean hasNext() {
        boolean hasNext = this.iterator.hasNext();
        if (!hasNext) {
            this.close();
        }
        return hasNext;
    }

    public abstract V map(T var1);

    public V next() {
        try {
            return this.map(this.iterator.next());
        }
        catch (NoSuchElementException e) {
            this.close();
            throw e;
        }
    }

    public void remove() {
        this.iterator.remove();
    }
}

