/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.arguments;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.commandline.arguments.OptionalBooleanArg;
import org.neo4j.helpers.Args;

class OptionalBooleanArgTest {
    OptionalBooleanArgTest() {
    }

    @Test
    void parsesValues1() {
        OptionalBooleanArg arg = new OptionalBooleanArg("foo", false, "");
        Assertions.assertEquals((Object)"false", (Object)arg.parse(Args.parse((String[])new String[0])));
        Assertions.assertEquals((Object)"false", (Object)arg.parse(Args.parse((String[])new String[]{"--foo=false"})));
        Assertions.assertEquals((Object)"true", (Object)arg.parse(Args.parse((String[])new String[]{"--foo=true"})));
        Assertions.assertEquals((Object)"true", (Object)arg.parse(Args.parse((String[])new String[]{"--foo"})));
    }

    @Test
    void parsesValues2() {
        OptionalBooleanArg arg = new OptionalBooleanArg("foo", true, "");
        Assertions.assertEquals((Object)"true", (Object)arg.parse(Args.parse((String[])new String[0])));
        Assertions.assertEquals((Object)"false", (Object)arg.parse(Args.parse((String[])new String[]{"--foo=false"})));
        Assertions.assertEquals((Object)"true", (Object)arg.parse(Args.parse((String[])new String[]{"--foo=true"})));
        Assertions.assertEquals((Object)"true", (Object)arg.parse(Args.parse((String[])new String[]{"--foo"})));
    }

    @Test
    void usageTest() {
        OptionalBooleanArg arg = new OptionalBooleanArg("foo", true, "");
        Assertions.assertEquals((Object)"[--foo[=<true|false>]]", (Object)arg.usage());
    }
}

