/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.ssl;

import org.neo4j.configuration.ssl.ClientAuth;

public enum SslPolicyScope {
    BOLT(ClientAuth.OPTIONAL, "certificates/bolt"),
    HTTPS(ClientAuth.OPTIONAL, "certificates/https"),
    CLUSTER(ClientAuth.REQUIRE, "certificates/cluster"),
    BACKUP(ClientAuth.REQUIRE, "certificates/backup"),
    FABRIC(ClientAuth.NONE, "certificates/fabric", true),
    TESTING(ClientAuth.REQUIRE, "certificates/testing");

    final ClientAuth authDefault;
    final String baseDir;
    private final boolean clientOnly;

    private SslPolicyScope(ClientAuth authDefault, String baseDir) {
        this(authDefault, baseDir, false);
    }

    private SslPolicyScope(ClientAuth authDefault, String baseDir, boolean clientOnly) {
        this.authDefault = authDefault;
        this.baseDir = baseDir;
        this.clientOnly = clientOnly;
    }

    public boolean isClientOnly() {
        return this.clientOnly;
    }

    static SslPolicyScope fromName(String name) {
        for (SslPolicyScope value : SslPolicyScope.values()) {
            if (!value.name().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }
}

