/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.legacy.consistency.repair;

import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.legacy.consistency.repair.RecordSet;
import org.neo4j.legacy.consistency.repair.RelationshipChainExplorer;
import org.neo4j.legacy.consistency.repair.RelationshipNodeField;

public class OwningNodeRelationshipChain {
    private final RelationshipChainExplorer relationshipChainExplorer;
    private final RecordStore<NodeRecord> nodeStore;

    public OwningNodeRelationshipChain(RelationshipChainExplorer relationshipChainExplorer, RecordStore<NodeRecord> nodeStore) {
        this.relationshipChainExplorer = relationshipChainExplorer;
        this.nodeStore = nodeStore;
    }

    public RecordSet<RelationshipRecord> findRelationshipChainsThatThisRecordShouldBelongTo(RelationshipRecord relationship) {
        RecordSet<RelationshipRecord> records = new RecordSet<RelationshipRecord>();
        for (RelationshipNodeField field : RelationshipNodeField.values()) {
            long nodeId = field.get(relationship);
            NodeRecord nodeRecord = (NodeRecord)this.nodeStore.forceGetRecord(nodeId);
            records.addAll(this.relationshipChainExplorer.followChainFromNode(nodeId, nodeRecord.getNextRel()));
        }
        return records;
    }
}

