/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.HashMap;
import java.util.Map;
import java.util.OptionalLong;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.SchemaRuleKey;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaProcessor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;

public class SchemaRecordCheck
implements RecordCheck<SchemaRecord, ConsistencyReport.SchemaConsistencyReport> {
    static final String CONSTRAINT_OBLIGATION = "UNIQUENESS_CONSTRAINT";
    static final String INDEX_OBLIGATION = "CONSTRAINT_INDEX_RULE";
    final SchemaRuleAccess ruleAccess;
    final IndexAccessors indexAccessors;
    private final Map<Long, SchemaRecord> indexObligations;
    private final Map<Long, String> indexNameObligations;
    private final Map<Long, SchemaRecord> constraintObligations;
    private final Map<SchemaRuleKey, SchemaRecord> verifiedRulesWithRecords;
    private final Map<String, NamedSchema> verifiedRuleNames;
    private final CheckStrategy strategy;
    private static final ComparativeRecordChecker<SchemaRecord, LabelTokenRecord, ConsistencyReport.SchemaConsistencyReport> VALID_LABEL = (record, labelTokenRecord, engine, records) -> {
        if (!labelTokenRecord.inUse()) {
            ((ConsistencyReport.SchemaConsistencyReport)engine.report()).labelNotInUse((LabelTokenRecord)labelTokenRecord);
        }
    };
    private static final ComparativeRecordChecker<SchemaRecord, RelationshipTypeTokenRecord, ConsistencyReport.SchemaConsistencyReport> VALID_RELATIONSHIP_TYPE = (record, relTypeTokenRecord, engine, records) -> {
        if (!relTypeTokenRecord.inUse()) {
            ((ConsistencyReport.SchemaConsistencyReport)engine.report()).relationshipTypeNotInUse((RelationshipTypeTokenRecord)relTypeTokenRecord);
        }
    };
    private static final ComparativeRecordChecker<SchemaRecord, PropertyKeyTokenRecord, ConsistencyReport.SchemaConsistencyReport> VALID_PROPERTY_KEY = (record, propertyKeyTokenRecord, engine, records) -> {
        if (!propertyKeyTokenRecord.inUse()) {
            ((ConsistencyReport.SchemaConsistencyReport)engine.report()).propertyKeyNotInUse((PropertyKeyTokenRecord)propertyKeyTokenRecord);
        }
    };

    public SchemaRecordCheck(SchemaRuleAccess ruleAccess, IndexAccessors indexAccessors) {
        this.ruleAccess = ruleAccess;
        this.indexAccessors = indexAccessors;
        this.indexObligations = new HashMap<Long, SchemaRecord>();
        this.indexNameObligations = new HashMap<Long, String>();
        this.constraintObligations = new HashMap<Long, SchemaRecord>();
        this.verifiedRulesWithRecords = new HashMap<SchemaRuleKey, SchemaRecord>();
        this.verifiedRuleNames = new HashMap<String, NamedSchema>();
        this.strategy = new RulesCheckStrategy();
    }

    private SchemaRecordCheck(SchemaRuleAccess ruleAccess, IndexAccessors indexAccessors, Map<Long, SchemaRecord> indexObligations, Map<Long, String> indexNameObligations, Map<Long, SchemaRecord> constraintObligations, Map<SchemaRuleKey, SchemaRecord> verifiedRulesWithRecords, Map<String, NamedSchema> verifiedRuleNames, CheckStrategy strategy) {
        this.ruleAccess = ruleAccess;
        this.indexAccessors = indexAccessors;
        this.indexObligations = indexObligations;
        this.indexNameObligations = indexNameObligations;
        this.constraintObligations = constraintObligations;
        this.verifiedRulesWithRecords = verifiedRulesWithRecords;
        this.verifiedRuleNames = verifiedRuleNames;
        this.strategy = strategy;
    }

    public SchemaRecordCheck forObligationChecking() {
        return new SchemaRecordCheck(this.ruleAccess, this.indexAccessors, this.indexObligations, this.indexNameObligations, this.constraintObligations, this.verifiedRulesWithRecords, this.verifiedRuleNames, new ObligationsCheckStrategy());
    }

    @Override
    public void check(SchemaRecord record, CheckerEngine<SchemaRecord, ConsistencyReport.SchemaConsistencyReport> engine, RecordAccess records) {
        if (record.inUse()) {
            SchemaRule rule;
            try {
                rule = this.ruleAccess.loadSingleSchemaRule(record.getId());
            }
            catch (MalformedSchemaRuleException e) {
                this.strategy.reportMalformedSchemaRule(engine.report());
                return;
            }
            if (rule instanceof IndexDescriptor) {
                this.strategy.checkIndexRule((IndexDescriptor)rule, record, records, engine);
            } else if (rule instanceof ConstraintDescriptor) {
                this.strategy.checkConstraintRule((ConstraintDescriptor)rule, record, records, engine);
            } else {
                engine.report().unsupportedSchemaRuleType(rule.getClass());
            }
        }
    }

    private void checkSchema(SchemaRule rule, SchemaRecord record, RecordAccess records, CheckerEngine<SchemaRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
        rule.schema().processWith((SchemaProcessor)new CheckSchema(engine, records));
        this.checkNamesAndDuplicates(rule, record, engine);
    }

    private SchemaRecord cloneRecord(SchemaRecord record) {
        try {
            return record.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError("SchemaRecords should be cloneable.", e);
        }
    }

    private void checkNamesAndDuplicates(SchemaRule rule, SchemaRecord record, CheckerEngine<SchemaRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
        String name;
        NamedSchema namedSchema;
        SchemaRecord previousContentRecord = this.verifiedRulesWithRecords.put(new SchemaRuleKey(rule), this.cloneRecord(record));
        if (previousContentRecord != null) {
            engine.report().duplicateRuleContent(previousContentRecord);
        }
        if ((namedSchema = this.verifiedRuleNames.get(name = rule.getName())) == null) {
            namedSchema = new NamedSchema();
            this.verifiedRuleNames.put(name, namedSchema);
        }
        if (rule instanceof ConstraintDescriptor) {
            ConstraintDescriptor constraint = (ConstraintDescriptor)rule;
            if (namedSchema.constraint != null) {
                engine.report().duplicateRuleName(namedSchema.constraintRecord, name);
            }
            namedSchema.constraint = constraint;
            namedSchema.constraintRecord = record;
            if (namedSchema.index != null) {
                IndexBackedConstraintDescriptor ibc;
                if (constraint.isIndexBackedConstraint() && (ibc = constraint.asIndexBackedConstraint()).hasOwnedIndexId() && ibc.ownedIndexId() == namedSchema.index.getId()) {
                    return;
                }
                if (namedSchema.indexRecord.getId() != rule.getId()) {
                    engine.report().duplicateRuleName(namedSchema.indexRecord, name);
                }
            }
        } else {
            OptionalLong owningConstraintId;
            IndexDescriptor index = (IndexDescriptor)rule;
            if (namedSchema.index != null && namedSchema.indexRecord.getId() != index.getId()) {
                engine.report().duplicateRuleName(namedSchema.indexRecord, name);
            }
            namedSchema.index = index;
            namedSchema.indexRecord = record;
            if (namedSchema.constraint != null && ((owningConstraintId = index.getOwningConstraintId()).isEmpty() || owningConstraintId.getAsLong() != namedSchema.constraint.getId())) {
                engine.report().duplicateRuleName(namedSchema.constraintRecord, name);
            }
        }
    }

    private static class NamedSchema {
        private IndexDescriptor index;
        private ConstraintDescriptor constraint;
        private SchemaRecord indexRecord;
        private SchemaRecord constraintRecord;

        private NamedSchema() {
        }
    }

    static class CheckSchema
    implements SchemaProcessor {
        private final CheckerEngine<SchemaRecord, ConsistencyReport.SchemaConsistencyReport> engine;
        private final RecordAccess records;

        CheckSchema(CheckerEngine<SchemaRecord, ConsistencyReport.SchemaConsistencyReport> engine, RecordAccess records) {
            this.engine = engine;
            this.records = records;
        }

        public void processSpecific(LabelSchemaDescriptor schema) {
            this.engine.comparativeCheck(this.records.label(schema.getLabelId()), VALID_LABEL);
            this.checkProperties(schema.getPropertyIds());
        }

        public void processSpecific(RelationTypeSchemaDescriptor schema) {
            this.engine.comparativeCheck(this.records.relationshipType(schema.getRelTypeId()), VALID_RELATIONSHIP_TYPE);
            this.checkProperties(schema.getPropertyIds());
        }

        public void processSpecific(SchemaDescriptor schema) {
            switch (schema.entityType()) {
                case NODE: {
                    for (int entityTokenId : schema.getEntityTokenIds()) {
                        this.engine.comparativeCheck(this.records.label(entityTokenId), VALID_LABEL);
                    }
                    break;
                }
                case RELATIONSHIP: {
                    for (int entityTokenId : schema.getEntityTokenIds()) {
                        this.engine.comparativeCheck(this.records.relationshipType(entityTokenId), VALID_RELATIONSHIP_TYPE);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Schema with given entity type is not supported: " + schema.entityType());
                }
            }
            this.checkProperties(schema.getPropertyIds());
        }

        private void checkProperties(int[] propertyIds) {
            for (int propertyId : propertyIds) {
                this.engine.comparativeCheck(this.records.propertyKey(propertyId), VALID_PROPERTY_KEY);
            }
        }
    }

    private class ObligationsCheckStrategy
    implements CheckStrategy {
        private ObligationsCheckStrategy() {
        }

        @Override
        public void checkIndexRule(IndexDescriptor rule, SchemaRecord record, RecordAccess records, CheckerEngine<SchemaRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
            if (rule.isUnique()) {
                String nameObligation;
                SchemaRecord obligation = SchemaRecordCheck.this.indexObligations.get(rule.getId());
                if (obligation == null) {
                    if (rule.getOwningConstraintId().isPresent()) {
                        engine.report().missingObligation(SchemaRecordCheck.CONSTRAINT_OBLIGATION);
                    }
                } else if (obligation.getId() != rule.getOwningConstraintId().getAsLong()) {
                    engine.report().constraintIndexRuleNotReferencingBack(obligation);
                }
                if ((nameObligation = SchemaRecordCheck.this.indexNameObligations.get(rule.getId())) != null && !nameObligation.equals(rule.getName())) {
                    engine.report().constraintIndexNameDoesNotMatchConstraintName(record, rule.getName(), nameObligation);
                }
            }
            if (SchemaRecordCheck.this.indexAccessors.notOnlineRules().contains(rule)) {
                engine.report().schemaRuleNotOnline((SchemaRule)rule);
            }
        }

        @Override
        public void checkConstraintRule(ConstraintDescriptor constraint, SchemaRecord record, RecordAccess records, CheckerEngine<SchemaRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
            if (constraint.isIndexBackedConstraint()) {
                SchemaRecord obligation = SchemaRecordCheck.this.constraintObligations.get(constraint.getId());
                if (obligation == null) {
                    engine.report().missingObligation(SchemaRecordCheck.INDEX_OBLIGATION);
                } else if (obligation.getId() != constraint.asIndexBackedConstraint().ownedIndexId()) {
                    engine.report().uniquenessConstraintNotReferencingBack(obligation);
                }
            }
        }

        @Override
        public void reportMalformedSchemaRule(ConsistencyReport.SchemaConsistencyReport report) {
        }
    }

    private class RulesCheckStrategy
    implements CheckStrategy {
        private RulesCheckStrategy() {
        }

        @Override
        public void checkIndexRule(IndexDescriptor rule, SchemaRecord record, RecordAccess records, CheckerEngine<SchemaRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
            SchemaRecord previousObligation;
            SchemaRecordCheck.this.checkSchema((SchemaRule)rule, record, records, engine);
            if (rule.isUnique() && rule.getOwningConstraintId().isPresent() && (previousObligation = SchemaRecordCheck.this.constraintObligations.put(rule.getOwningConstraintId().getAsLong(), SchemaRecordCheck.this.cloneRecord(record))) != null) {
                engine.report().duplicateObligation(previousObligation);
            }
        }

        @Override
        public void checkConstraintRule(ConstraintDescriptor constraint, SchemaRecord record, RecordAccess records, CheckerEngine<SchemaRecord, ConsistencyReport.SchemaConsistencyReport> engine) {
            SchemaRecordCheck.this.checkSchema((SchemaRule)constraint, record, records, engine);
            if (constraint.isIndexBackedConstraint()) {
                IndexBackedConstraintDescriptor indexBacked = constraint.asIndexBackedConstraint();
                SchemaRecord previousObligation = SchemaRecordCheck.this.indexObligations.put(indexBacked.ownedIndexId(), SchemaRecordCheck.this.cloneRecord(record));
                if (previousObligation != null) {
                    engine.report().duplicateObligation(previousObligation);
                }
                SchemaRecordCheck.this.indexNameObligations.put(indexBacked.ownedIndexId(), indexBacked.getName());
            }
        }

        @Override
        public void reportMalformedSchemaRule(ConsistencyReport.SchemaConsistencyReport report) {
            report.malformedSchemaRule();
        }
    }

    private static interface CheckStrategy {
        public void checkIndexRule(IndexDescriptor var1, SchemaRecord var2, RecordAccess var3, CheckerEngine<SchemaRecord, ConsistencyReport.SchemaConsistencyReport> var4);

        public void checkConstraintRule(ConstraintDescriptor var1, SchemaRecord var2, RecordAccess var3, CheckerEngine<SchemaRecord, ConsistencyReport.SchemaConsistencyReport> var4);

        public void reportMalformedSchemaRule(ConsistencyReport.SchemaConsistencyReport var1);
    }
}

