/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.SchemaRuleKey;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.newchecker.CheckerContext;
import org.neo4j.consistency.newchecker.ParallelExecution;
import org.neo4j.consistency.newchecker.RecordLoading;
import org.neo4j.consistency.newchecker.RecordReader;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.recordstorage.SchemaStorage;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaProcessor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.storemigration.legacy.SchemaRuleKind;
import org.neo4j.token.TokenHolders;

class SchemaChecker {
    private final NeoStores neoStores;
    private final TokenHolders tokenHolders;
    private final IndexAccessors indexAccessors;
    private final CheckerContext context;
    private final SchemaStore schemaStore;
    private final ConsistencyReport.Reporter reporter;
    private final ParallelExecution execution;

    SchemaChecker(CheckerContext context) {
        this.neoStores = context.neoStores;
        this.tokenHolders = context.tokenHolders;
        this.indexAccessors = context.indexAccessors;
        this.context = context;
        this.schemaStore = this.neoStores.getSchemaStore();
        this.reporter = context.reporter;
        this.execution = context.execution;
    }

    void check(MutableIntObjectMap<MutableIntSet> mandatoryNodeProperties, MutableIntObjectMap<MutableIntSet> mandatoryRelationshipProperties) throws Exception {
        this.checkSchema(mandatoryNodeProperties, mandatoryRelationshipProperties);
        this.checkTokens();
    }

    private void checkSchema(MutableIntObjectMap<MutableIntSet> mandatoryNodeProperties, MutableIntObjectMap<MutableIntSet> mandatoryRelationshipProperties) {
        long highId = this.schemaStore.getHighId();
        try (RecordReader<SchemaRecord> schemaReader = new RecordReader<SchemaRecord>((CommonAbstractStore<SchemaRecord, ?>)this.schemaStore);){
            HashMap<Long, SchemaRecord> indexObligations = new HashMap<Long, SchemaRecord>();
            HashMap<Long, SchemaRecord> constraintObligations = new HashMap<Long, SchemaRecord>();
            HashMap<SchemaRuleKey, SchemaRecord> verifiedRulesWithRecords = new HashMap<SchemaRuleKey, SchemaRecord>();
            SchemaStorage schemaStorage = new SchemaStorage(this.schemaStore, this.tokenHolders);
            this.buildObligationsMap(highId, schemaReader, schemaStorage, indexObligations, constraintObligations, verifiedRulesWithRecords);
            this.performSchemaCheck(highId, schemaReader, indexObligations, constraintObligations, schemaStorage, mandatoryNodeProperties, mandatoryRelationshipProperties);
        }
    }

    private void buildObligationsMap(long highId, RecordReader<SchemaRecord> reader, SchemaStorage schemaStorage, Map<Long, SchemaRecord> indexObligations, Map<Long, SchemaRecord> constraintObligations, Map<SchemaRuleKey, SchemaRecord> verifiedRulesWithRecords) {
        for (long id = (long)this.schemaStore.getNumberOfReservedLowIds(); id < highId && !this.context.isCancelled(); ++id) {
            try {
                SchemaRecord previousObligation;
                IndexDescriptor rule;
                SchemaRecord record = reader.read(id);
                if (!record.inUse()) continue;
                SchemaRule schemaRule = schemaStorage.loadSingleSchemaRule(id);
                SchemaRecord previousContentRecord = verifiedRulesWithRecords.put(new SchemaRuleKey(schemaRule), RecordLoading.safeClone(record));
                if (previousContentRecord != null) {
                    this.reporter.forSchema(record).duplicateRuleContent(previousContentRecord);
                }
                if (schemaRule instanceof IndexDescriptor) {
                    rule = (IndexDescriptor)schemaRule;
                    if (!rule.isUnique() || !rule.getOwningConstraintId().isPresent() || (previousObligation = constraintObligations.put(rule.getOwningConstraintId().getAsLong(), RecordLoading.safeClone(record))) == null) continue;
                    this.reporter.forSchema(record).duplicateObligation(previousObligation);
                    continue;
                }
                if (!(schemaRule instanceof ConstraintDescriptor) || !(rule = (ConstraintDescriptor)schemaRule).enforcesUniqueness() || (previousObligation = indexObligations.put(rule.asIndexBackedConstraint().ownedIndexId(), RecordLoading.safeClone(record))) == null) continue;
                this.reporter.forSchema(record).duplicateObligation(previousObligation);
                continue;
            }
            catch (MalformedSchemaRuleException malformedSchemaRuleException) {
                // empty catch block
            }
        }
    }

    private void performSchemaCheck(long highId, RecordReader<SchemaRecord> reader, Map<Long, SchemaRecord> indexObligations, Map<Long, SchemaRecord> constraintObligations, SchemaStorage schemaStorage, MutableIntObjectMap<MutableIntSet> mandatoryNodeProperties, MutableIntObjectMap<MutableIntSet> mandatoryRelationshipProperties) {
        SchemaRecord record = reader.record();
        BasicSchemaCheck basicSchemaCheck = new BasicSchemaCheck(record);
        MandatoryPropertiesBuilder mandatoryPropertiesBuilder = new MandatoryPropertiesBuilder(mandatoryNodeProperties, mandatoryRelationshipProperties);
        for (long id = (long)this.schemaStore.getNumberOfReservedLowIds(); id < highId && !this.context.isCancelled(); ++id) {
            try {
                SchemaRecord obligation;
                IndexDescriptor rule;
                reader.read(id);
                if (!record.inUse()) continue;
                SchemaRule schemaRule = schemaStorage.loadSingleSchemaRule(id);
                schemaRule.schema().processWith((SchemaProcessor)basicSchemaCheck);
                if (schemaRule instanceof IndexDescriptor) {
                    rule = (IndexDescriptor)schemaRule;
                    if (rule.isUnique()) {
                        obligation = indexObligations.get(rule.getId());
                        if (obligation == null) {
                            if (rule.getOwningConstraintId().isPresent()) {
                                this.reporter.forSchema(record).missingObligation(SchemaRuleKind.UNIQUENESS_CONSTRAINT.name());
                            }
                        } else if (obligation.getId() != rule.getOwningConstraintId().getAsLong()) {
                            this.reporter.forSchema(record).constraintIndexRuleNotReferencingBack(obligation);
                        }
                    }
                    if (!this.indexAccessors.notOnlineRules().contains(rule)) continue;
                    this.reporter.forSchema(record).schemaRuleNotOnline((SchemaRule)rule);
                    continue;
                }
                if (schemaRule instanceof ConstraintDescriptor) {
                    rule = (ConstraintDescriptor)schemaRule;
                    if (rule.enforcesUniqueness()) {
                        obligation = constraintObligations.get(rule.getId());
                        if (obligation == null) {
                            this.reporter.forSchema(record).missingObligation(SchemaRuleKind.CONSTRAINT_INDEX_RULE.name());
                        } else if (obligation.getId() != rule.asIndexBackedConstraint().ownedIndexId()) {
                            this.reporter.forSchema(record).uniquenessConstraintNotReferencingBack(obligation);
                        }
                    }
                    if (!rule.enforcesPropertyExistence()) continue;
                    rule.schema().processWith((SchemaProcessor)mandatoryPropertiesBuilder);
                    continue;
                }
                this.reporter.forSchema(record).unsupportedSchemaRuleType(null);
                continue;
            }
            catch (MalformedSchemaRuleException e) {
                this.reporter.forSchema(record).malformedSchemaRule();
            }
        }
    }

    private void checkTokens() throws Exception {
        this.execution.run(this.getClass().getSimpleName() + "-checkTokens", () -> this.checkTokens((TokenStore)this.neoStores.getLabelTokenStore(), (Function)this.reporter::forLabelName, dynamicRecord -> this.reporter.forDynamicBlock(RecordType.LABEL_NAME, (DynamicRecord)dynamicRecord)), () -> this.checkTokens((TokenStore)this.neoStores.getRelationshipTypeTokenStore(), (Function)this.reporter::forRelationshipTypeName, dynamicRecord -> this.reporter.forDynamicBlock(RecordType.RELATIONSHIP_TYPE_NAME, (DynamicRecord)dynamicRecord)), () -> this.checkTokens((TokenStore)this.neoStores.getPropertyKeyTokenStore(), (Function)this.reporter::forPropertyKey, dynamicRecord -> this.reporter.forDynamicBlock(RecordType.PROPERTY_KEY_NAME, (DynamicRecord)dynamicRecord)));
    }

    private <R extends TokenRecord> void checkTokens(TokenStore<R> store, Function<R, ConsistencyReport.NameConsistencyReport> report, Function<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> dynamicRecordReport) {
        DynamicStringStore nameStore = store.getNameStore();
        DynamicRecord nameRecord = (DynamicRecord)nameStore.newRecord();
        long highId = store.getHighId();
        MutableLongSet seenNameRecordIds = LongSets.mutable.empty();
        int blockSize = store.getNameStore().getRecordDataSize();
        try (RecordReader tokenReader = new RecordReader(store);
             RecordReader<DynamicRecord> nameReader = new RecordReader<DynamicRecord>((CommonAbstractStore<DynamicRecord, ?>)store.getNameStore());){
            for (long id = 0L; id < highId; ++id) {
                TokenRecord record = (TokenRecord)tokenReader.read(id);
                if (!record.inUse() || Record.NULL_REFERENCE.is((long)record.getNameId())) continue;
                RecordLoading.safeLoadDynamicRecordChain(r -> {}, nameReader, seenNameRecordIds, record.getNameId(), blockSize, (i, r) -> ((ConsistencyReport.DynamicConsistencyReport)dynamicRecordReport.apply(nameRecord)).circularReferenceNext((DynamicRecord)r), (i, r) -> ((ConsistencyReport.NameConsistencyReport)report.apply(record)).nameBlockNotInUse(nameRecord), (i, r) -> ((ConsistencyReport.DynamicConsistencyReport)dynamicRecordReport.apply(nameRecord)).nextNotInUse((DynamicRecord)r), (i, r) -> ((ConsistencyReport.DynamicConsistencyReport)dynamicRecordReport.apply((DynamicRecord)r)).emptyBlock(), r -> ((ConsistencyReport.DynamicConsistencyReport)dynamicRecordReport.apply((DynamicRecord)r)).recordNotFullReferencesNext(), r -> ((ConsistencyReport.DynamicConsistencyReport)dynamicRecordReport.apply((DynamicRecord)r)).invalidLength());
            }
        }
    }

    private class MandatoryPropertiesBuilder
    implements SchemaProcessor {
        private final MutableIntObjectMap<MutableIntSet> mandatoryNodeProperties;
        private final MutableIntObjectMap<MutableIntSet> mandatoryRelationshipProperties;

        MandatoryPropertiesBuilder(MutableIntObjectMap<MutableIntSet> mandatoryNodeProperties, MutableIntObjectMap<MutableIntSet> mandatoryRelationshipProperties) {
            this.mandatoryNodeProperties = mandatoryNodeProperties;
            this.mandatoryRelationshipProperties = mandatoryRelationshipProperties;
        }

        public void processSpecific(LabelSchemaDescriptor schema) {
            for (int entityToken : schema.getEntityTokenIds()) {
                this.putMandatoryProperty(this.mandatoryNodeProperties, entityToken, schema.getPropertyIds());
            }
        }

        public void processSpecific(RelationTypeSchemaDescriptor schema) {
            this.putMandatoryProperty(this.mandatoryRelationshipProperties, schema.getRelTypeId(), schema.getPropertyIds());
        }

        private void putMandatoryProperty(MutableIntObjectMap<MutableIntSet> mandatoryProperties, int entityToken, int[] propertyIds) {
            MutableIntSet keys = (MutableIntSet)mandatoryProperties.get(entityToken);
            if (keys == null) {
                keys = new IntHashSet();
                mandatoryProperties.put(entityToken, (Object)keys);
            }
            keys.addAll(propertyIds);
        }

        public void processSpecific(SchemaDescriptor schema) {
            throw new UnsupportedOperationException();
        }
    }

    private class BasicSchemaCheck
    implements SchemaProcessor {
        private final SchemaRecord record;

        BasicSchemaCheck(SchemaRecord record) {
            this.record = record;
        }

        public void processSpecific(LabelSchemaDescriptor schema) {
            RecordLoading.checkValidToken(null, schema.getLabelId(), SchemaChecker.this.tokenHolders.labelTokens(), SchemaChecker.this.neoStores.getLabelTokenStore(), (record, id) -> {}, (ignore, token) -> SchemaChecker.this.reporter.forSchema(this.record).labelNotInUse((LabelTokenRecord)token));
            this.checkValidPropertyKeyIds((SchemaDescriptor)schema);
        }

        public void processSpecific(RelationTypeSchemaDescriptor schema) {
            RecordLoading.checkValidToken(null, schema.getRelTypeId(), SchemaChecker.this.tokenHolders.relationshipTypeTokens(), SchemaChecker.this.neoStores.getRelationshipTypeTokenStore(), (record, id) -> {}, (ignore, token) -> SchemaChecker.this.reporter.forSchema(this.record).relationshipTypeNotInUse((RelationshipTypeTokenRecord)token));
            this.checkValidPropertyKeyIds((SchemaDescriptor)schema);
        }

        public void processSpecific(SchemaDescriptor schema) {
            switch (schema.entityType()) {
                case NODE: {
                    for (int labelTokenId : schema.getEntityTokenIds()) {
                        RecordLoading.checkValidToken(null, labelTokenId, SchemaChecker.this.tokenHolders.labelTokens(), SchemaChecker.this.neoStores.getLabelTokenStore(), (record, id) -> {}, (ignore, token) -> SchemaChecker.this.reporter.forSchema(this.record).labelNotInUse((LabelTokenRecord)token));
                    }
                    break;
                }
                case RELATIONSHIP: {
                    for (int relationshipTypeTokenId : schema.getEntityTokenIds()) {
                        RecordLoading.checkValidToken(null, relationshipTypeTokenId, SchemaChecker.this.tokenHolders.relationshipTypeTokens(), SchemaChecker.this.neoStores.getRelationshipTypeTokenStore(), (record, id) -> {}, (ignore, token) -> SchemaChecker.this.reporter.forSchema(this.record).relationshipTypeNotInUse((RelationshipTypeTokenRecord)token));
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Schema with given entity type is not supported: " + schema.entityType());
                }
            }
            this.checkValidPropertyKeyIds(schema);
        }

        private void checkValidPropertyKeyIds(SchemaDescriptor schema) {
            for (int propertyKeyId : schema.getPropertyIds()) {
                RecordLoading.checkValidToken(null, propertyKeyId, SchemaChecker.this.tokenHolders.propertyKeyTokens(), SchemaChecker.this.neoStores.getPropertyKeyTokenStore(), (record, id) -> {}, (ignore, token) -> SchemaChecker.this.reporter.forSchema(this.record).propertyKeyNotInUse((PropertyKeyTokenRecord)token));
            }
        }
    }
}

