/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import java.io.IOException;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.CommonAbstractStore;

class StorePagePrefetcher {
    public static final Monitor NO_MONITOR = () -> {};
    private final CommonAbstractStore<?, ?> store;
    private final int readAheadSize;
    private final BooleanSupplier cancellation;
    private final Monitor monitor;

    StorePagePrefetcher(CommonAbstractStore<?, ?> store, int readAheadSize, BooleanSupplier cancellation, Monitor monitor) {
        this.store = store;
        this.readAheadSize = readAheadSize;
        this.cancellation = cancellation;
        this.monitor = monitor;
    }

    void prefetch(LongSupplier currentReadingPage, boolean forwards) throws IOException {
        if (forwards) {
            this.forwards(currentReadingPage);
        } else {
            this.backwards(currentReadingPage);
        }
    }

    private void forwards(LongSupplier currentReadingPage) throws IOException {
        try (PageCursor cursor = this.store.openPageCursorForReading(0L);){
            block5: while (cursor.next() && !this.cancellation.getAsBoolean()) {
                long currentPageId = cursor.getCurrentPageId();
                while (currentPageId - currentReadingPage.getAsLong() >= (long)this.readAheadSize && !this.cancellation.getAsBoolean()) {
                    this.monitor.awaitingReader();
                    if (!this.sleepAWhile()) continue;
                    continue block5;
                }
            }
        }
    }

    private void backwards(LongSupplier currentReadingPage) throws IOException {
        try (PageCursor cursor = this.store.openPageCursorForReading(0L);){
            long endPageId = this.store.getHighId() / (long)this.store.getRecordsPerPage();
            long startPageId = Math.max(0L, endPageId - (long)this.readAheadSize);
            while (!(startPageId <= 0L && endPageId <= 0L || this.cancellation.getAsBoolean())) {
                cursor.next(startPageId);
                while (cursor.getCurrentPageId() < endPageId && !this.cancellation.getAsBoolean() && cursor.next()) {
                }
                while (currentReadingPage.getAsLong() - startPageId > (long)(this.readAheadSize / 2) && !this.cancellation.getAsBoolean()) {
                    this.monitor.awaitingReader();
                    if (!this.sleepAWhile()) continue;
                }
                endPageId = Math.max(0L, startPageId);
                startPageId = Math.max(0L, endPageId - (long)this.readAheadSize);
            }
        }
    }

    private boolean sleepAWhile() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return true;
        }
        return false;
    }

    public static interface Monitor {
        public void awaitingReader();
    }
}

