/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_1.planner.logical;

import org.neo4j.cypher.internal.compiler.v2_1.ast.PatternExpression;
import org.neo4j.cypher.internal.compiler.v2_1.planner.QueryGraph;
import org.neo4j.cypher.internal.compiler.v2_1.planner.logical.CandidateGenerator;
import org.neo4j.cypher.internal.compiler.v2_1.planner.logical.CandidateGenerator$;
import org.neo4j.cypher.internal.compiler.v2_1.planner.logical.CandidateList;
import org.neo4j.cypher.internal.compiler.v2_1.planner.logical.GreedyQueryGraphSolver$;
import org.neo4j.cypher.internal.compiler.v2_1.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.v2_1.planner.logical.PlanTable;
import org.neo4j.cypher.internal.compiler.v2_1.planner.logical.PlanTable$;
import org.neo4j.cypher.internal.compiler.v2_1.planner.logical.PlanningStrategyConfiguration;
import org.neo4j.cypher.internal.compiler.v2_1.planner.logical.QueryGraphSolver;
import org.neo4j.cypher.internal.compiler.v2_1.planner.logical.QueryGraphSolver$class;
import org.neo4j.cypher.internal.compiler.v2_1.planner.logical.expandsOrJoins$;
import org.neo4j.cypher.internal.compiler.v2_1.planner.logical.findShortestPaths$;
import org.neo4j.cypher.internal.compiler.v2_1.planner.logical.optionalMatches$;
import org.neo4j.cypher.internal.compiler.v2_1.planner.logical.plans.QueryPlan;
import org.neo4j.cypher.internal.compiler.v2_1.planner.logical.steps.cartesianProduct$;
import org.neo4j.cypher.internal.helpers.Converge.iterateUntilConverged$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001'\t1rI]3fIf\fV/\u001a:z\u000fJ\f\u0007\u000f[*pYZ,'O\u0003\u0002\u0004\t\u00059An\\4jG\u0006d'BA\u0003\u0007\u0003\u001d\u0001H.\u00198oKJT!a\u0002\u0005\u0002\tY\u0014t,\r\u0006\u0003\u0013)\t\u0001bY8na&dWM\u001d\u0006\u0003\u00171\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001b9\taaY=qQ\u0016\u0014(BA\b\u0011\u0003\u0015qWm\u001c\u001bk\u0015\u0005\t\u0012aA8sO\u000e\u00011c\u0001\u0001\u00155A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\u0004\"a\u0007\u000f\u000e\u0003\tI!!\b\u0002\u0003!E+XM]=He\u0006\u0004\bnU8mm\u0016\u0014\b\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\r\r|gNZ5h!\tY\u0012%\u0003\u0002#\u0005\ti\u0002\u000b\\1o]&twm\u0015;sCR,w-_\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003%\u0001\u0011\u0005Q%\u0001\u0004=S:LGO\u0010\u000b\u0003M\u001d\u0002\"a\u0007\u0001\t\u000f}\u0019\u0003\u0013!a\u0001A!)\u0011\u0006\u0001C\u0001U\u0005!\u0001\u000f\\1o)\tYs\n\u0006\u0003-e]R\u0005CA\u00171\u001b\u0005q#BA\u0018\u0003\u0003\u0015\u0001H.\u00198t\u0013\t\tdFA\u0005Rk\u0016\u0014\u0018\u0010\u00157b]\")1\u0007\u000ba\u0002i\u000591m\u001c8uKb$\bCA\u000e6\u0013\t1$A\u0001\fM_\u001eL7-\u00197QY\u0006tg.\u001b8h\u0007>tG/\u001a=u\u0011\u0015A\u0004\u0006q\u0001:\u0003M\u0019XOY)vKJLHj\\8lkB$\u0016M\u00197f!\u0011QT\b\u0011$\u000f\u0005UY\u0014B\u0001\u001f\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0004\u001b\u0006\u0004(B\u0001\u001f\u0017!\t\tE)D\u0001C\u0015\t\u0019e!A\u0002bgRL!!\u0012\"\u0003#A\u000bG\u000f^3s]\u0016C\bO]3tg&|g\u000e\u0005\u0002H\u00116\tA!\u0003\u0002J\t\tQ\u0011+^3ss\u001e\u0013\u0018\r\u001d5\t\u000f-C\u0003\u0013!a\u0002\u0019\u0006AA.Z1g!2\fg\u000eE\u0002\u0016\u001b2J!A\u0014\f\u0003\r=\u0003H/[8o\u0011\u0015\u0001\u0006\u00061\u0001G\u0003)\tX/\u001a:z\u000fJ\f\u0007\u000f\u001b\u0005\b%\u0002\t\n\u0011\"\u0011T\u00039\u0001H.\u00198%I\u00164\u0017-\u001e7uIQ\"\"\u0001\u00160+\u00051+6&\u0001,\u0011\u0005]cV\"\u0001-\u000b\u0005eS\u0016!C;oG\",7m[3e\u0015\tYf#\u0001\u0006b]:|G/\u0019;j_:L!!\u0018-\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0003Q#\u0002\u0007aiB\u0004a\u0005\u0005\u0005\t\u0012A1\u0002-\u001d\u0013X-\u001a3z#V,'/_$sCBD7k\u001c7wKJ\u0004\"a\u00072\u0007\u000f\u0005\u0011\u0011\u0011!E\u0001GN\u0011!\r\u0006\u0005\u0006I\t$\t!\u001a\u000b\u0002C\"9qMYI\u0001\n\u0003A\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'F\u0001jU\t\u0001S\u000b")
public class GreedyQueryGraphSolver
implements QueryGraphSolver {
    private final PlanningStrategyConfiguration config;

    public static PlanningStrategyConfiguration $lessinit$greater$default$1() {
        return GreedyQueryGraphSolver$.MODULE$.$lessinit$greater$default$1();
    }

    @Override
    public QueryPlan plan(QueryGraph queryGraph, LogicalPlanningContext context, Map<PatternExpression, QueryGraph> subQueryLookupTable, Option<QueryPlan> leafPlan) {
        Function2 select = this.config.applySelections().asFunctionInContext(context, subQueryLookupTable);
        Function1 pickBest = this.config.pickBestCandidate().asFunctionInContext(context, subQueryLookupTable);
        PlanTable leaves = this.generateLeafPlanTable$1(queryGraph, context, subQueryLookupTable, leafPlan, select, pickBest);
        PlanTable afterExpandOrJoin = (PlanTable)iterateUntilConverged$.MODULE$.apply(this.findBestPlan$1(expandsOrJoins$.MODULE$, queryGraph, context, subQueryLookupTable, select, pickBest)).apply((Object)leaves);
        PlanTable afterOptionalApplies = (PlanTable)iterateUntilConverged$.MODULE$.apply(this.findBestPlan$1(optionalMatches$.MODULE$, queryGraph, context, subQueryLookupTable, select, pickBest)).apply((Object)afterExpandOrJoin);
        PlanTable afterCartesianProduct = (PlanTable)iterateUntilConverged$.MODULE$.apply(this.findBestPlan$1(cartesianProduct$.MODULE$, queryGraph, context, subQueryLookupTable, select, pickBest)).apply((Object)afterOptionalApplies);
        return afterCartesianProduct.uniquePlan();
    }

    @Override
    public Option<QueryPlan> plan$default$4(QueryGraph queryGraph) {
        return None$.MODULE$;
    }

    private final PlanTable generateLeafPlanTable$1(QueryGraph queryGraph$1, LogicalPlanningContext context$1, Map subQueryLookupTable$1, Option leafPlan$1, Function2 select$1, Function1 pickBest$1) {
        Iterable<CandidateList> leafPlanCandidateLists = this.config.leafPlanners().candidateLists(queryGraph$1, context$1, (Map<PatternExpression, QueryGraph>)subQueryLookupTable$1);
        Iterable leafPlanCandidateListsWithSelections = (Iterable)leafPlanCandidateLists.map((Function1)new Serializable(this, queryGraph$1, select$1){
            public static final long serialVersionUID = 0L;
            public final QueryGraph queryGraph$1;
            public final Function2 select$1;

            public final CandidateList apply(CandidateList x$1) {
                return x$1.map((Function1<QueryPlan, QueryPlan>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final QueryPlan apply(QueryPlan x$2) {
                        return (QueryPlan)this.$outer.select$1.apply((Object)x$2, (Object)this.$outer.queryGraph$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.queryGraph$1 = queryGraph$1;
                this.select$1 = select$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        Iterable bestLeafPlans = (Iterable)leafPlanCandidateListsWithSelections.flatMap((Function1)new Serializable(this, pickBest$1){
            public static final long serialVersionUID = 0L;
            private final Function1 pickBest$1;

            public final Iterable<QueryPlan> apply(CandidateList x$3) {
                return Option$.MODULE$.option2Iterable((Option)this.pickBest$1.apply((Object)x$3));
            }
            {
                this.pickBest$1 = pickBest$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        PlanTable startTable = (PlanTable)Option$.MODULE$.option2Iterable(leafPlan$1).foldLeft((Object)PlanTable$.MODULE$.empty(), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final PlanTable apply(PlanTable x$4, QueryPlan x$5) {
                return x$4.$plus(x$5);
            }
        });
        return (PlanTable)bestLeafPlans.foldLeft((Object)startTable, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final PlanTable apply(PlanTable x$6, QueryPlan x$7) {
                return x$6.$plus(x$7);
            }
        });
    }

    private final Function1 findBestPlan$1(CandidateGenerator planGenerator, QueryGraph queryGraph$1, LogicalPlanningContext context$1, Map subQueryLookupTable$1, Function2 select$1, Function1 pickBest$1) {
        return new Serializable(this, queryGraph$1, context$1, subQueryLookupTable$1, select$1, pickBest$1, planGenerator){
            public static final long serialVersionUID = 0L;
            public final QueryGraph queryGraph$1;
            private final LogicalPlanningContext context$1;
            private final Map subQueryLookupTable$1;
            public final Function2 select$1;
            private final Function1 pickBest$1;
            private final CandidateGenerator planGenerator$1;

            public final PlanTable apply(PlanTable planTable) {
                CandidateGenerator<PlanTable> step = CandidateGenerator$.MODULE$.RichCandidateGenerator(this.planGenerator$1).$plus$bar$bar$plus(findShortestPaths$.MODULE$);
                Seq<QueryPlan> generated = ((CandidateList)step.apply(planTable, this.queryGraph$1, this.context$1, (Map<PatternExpression, QueryGraph>)this.subQueryLookupTable$1)).plans();
                Seq selected = (Seq)generated.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$findBestPlan$1$1 $outer;

                    public final QueryPlan apply(QueryPlan x$8) {
                        return (QueryPlan)this.$outer.select$1.apply((Object)x$8, (Object)this.$outer.queryGraph$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Option best = (Option)this.pickBest$1.apply((Object)new CandidateList((Seq<QueryPlan>)selected));
                return (PlanTable)best.fold((Function0)new Serializable(this, planTable){
                    public static final long serialVersionUID = 0L;
                    private final PlanTable planTable$1;

                    public final PlanTable apply() {
                        return this.planTable$1;
                    }
                    {
                        this.planTable$1 = planTable$1;
                    }
                }, (Function1)new Serializable(this, planTable){
                    public static final long serialVersionUID = 0L;
                    private final PlanTable planTable$1;

                    public final PlanTable apply(QueryPlan x$9) {
                        return this.planTable$1.$plus(x$9);
                    }
                    {
                        this.planTable$1 = planTable$1;
                    }
                });
            }
            {
                this.queryGraph$1 = queryGraph$1;
                this.context$1 = context$1;
                this.subQueryLookupTable$1 = subQueryLookupTable$1;
                this.select$1 = select$1;
                this.pickBest$1 = pickBest$1;
                this.planGenerator$1 = planGenerator$1;
            }
        };
    }

    public GreedyQueryGraphSolver(PlanningStrategyConfiguration config) {
        this.config = config;
        QueryGraphSolver$class.$init$(this);
    }
}

