/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.neo4j.cypherdsl.CypherQuery;
import org.neo4j.cypherdsl.Identifier;
import org.neo4j.cypherdsl.Parameter;
import org.neo4j.cypherdsl.PathRelationship;
import org.neo4j.cypherdsl.expression.Expression;
import org.neo4j.cypherdsl.expression.PathExpression;
import org.neo4j.cypherdsl.query.AbstractExpression;
import org.neo4j.cypherdsl.query.Direction;
import org.neo4j.cypherdsl.query.PropertyValue;
import org.neo4j.cypherdsl.query.PropertyValues;

public class Path
extends AbstractExpression
implements PathExpression {
    private final Expression node;
    private final Expression nodePropertyValues;
    private final PathRelationship relationship;

    Path(Expression node, PathRelationship relationship, Expression nodePropertyValues) {
        this.node = node;
        this.relationship = relationship;
        this.nodePropertyValues = nodePropertyValues;
    }

    public Path values(PropertyValue ... propertyValues) {
        return new Path(this.node, this.relationship, new PropertyValues(Arrays.asList(propertyValues)));
    }

    public Path values(Iterable<PropertyValue> propertyValues) {
        return new Path(this.node, this.relationship, new PropertyValues(propertyValues));
    }

    public Path values(Parameter propertyValues) {
        return new Path(this.node, this.relationship, propertyValues);
    }

    public PathRelationship out() {
        return new PathRelationship(this, Direction.OUT, null, Collections.emptyList(), null, null, null);
    }

    public PathRelationship out(String ... relationships) {
        return new PathRelationship(this, Direction.OUT, null, Arrays.asList(CypherQuery.identifiers(relationships)), null, null, null);
    }

    public PathRelationship out(Identifier ... relationships) {
        return new PathRelationship(this, Direction.OUT, null, Arrays.asList(relationships), null, null, null);
    }

    public PathRelationship out(Enum<?> ... relationships) {
        ArrayList<Identifier> relationshipNames = new ArrayList<Identifier>();
        for (Enum<?> relationship : relationships) {
            relationshipNames.add(CypherQuery.identifier(relationship.name()));
        }
        return new PathRelationship(this, Direction.OUT, null, relationshipNames, null, null, null);
    }

    public PathRelationship in() {
        return new PathRelationship(this, Direction.IN, null, Collections.emptyList(), null, null, null);
    }

    public PathRelationship in(String ... relationships) {
        return new PathRelationship(this, Direction.IN, null, Arrays.asList(CypherQuery.identifiers(relationships)), null, null, null);
    }

    public PathRelationship in(Identifier ... relationships) {
        return new PathRelationship(this, Direction.IN, null, Arrays.asList(relationships), null, null, null);
    }

    public PathRelationship in(Enum<?> ... relationships) {
        ArrayList<Identifier> relationshipNames = new ArrayList<Identifier>();
        for (Enum<?> relationship : relationships) {
            relationshipNames.add(CypherQuery.identifier(relationship.name()));
        }
        return new PathRelationship(this, Direction.IN, null, relationshipNames, null, null, null);
    }

    public PathRelationship both() {
        return new PathRelationship(this, Direction.BOTH, null, Collections.emptyList(), null, null, null);
    }

    public PathRelationship both(String ... relationships) {
        return new PathRelationship(this, Direction.BOTH, null, Arrays.asList(CypherQuery.identifiers(relationships)), null, null, null);
    }

    public PathRelationship both(Identifier ... relationships) {
        return new PathRelationship(this, Direction.BOTH, null, Arrays.asList(relationships), null, null, null);
    }

    public PathRelationship both(Enum<?> ... relationships) {
        ArrayList<Identifier> relationshipNames = new ArrayList<Identifier>();
        for (Enum<?> relationship : relationships) {
            relationshipNames.add(CypherQuery.identifier(relationship.name()));
        }
        return new PathRelationship(this, Direction.BOTH, null, relationshipNames, null, null, null);
    }

    @Override
    public void asString(StringBuilder builder) {
        if (this.relationship != null) {
            this.relationship.asString(builder);
        }
        builder.append('(');
        if (this.node != null) {
            this.node.asString(builder);
            if (this.nodePropertyValues != null) {
                builder.append(' ');
                this.nodePropertyValues.asString(builder);
            }
        } else if (this.nodePropertyValues != null) {
            this.nodePropertyValues.asString(builder);
        }
        builder.append(')');
    }
}

