/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.expression;

import org.neo4j.cypherdsl.Identifier;
import org.neo4j.cypherdsl.expression.Expression;
import org.neo4j.cypherdsl.expression.ReferenceExpression;
import org.neo4j.cypherdsl.expression.StringExpression;
import org.neo4j.cypherdsl.query.AbstractExpression;

public abstract class StartExpression
extends AbstractExpression {
    public final Identifier name;

    protected StartExpression(Identifier name) {
        this.name = name;
    }

    public static class StartRelationshipsIndex
    extends StartExpression {
        public final Identifier index;
        public final Identifier key;
        public final StringExpression value;

        public StartRelationshipsIndex(Identifier name, Identifier index, Identifier key, StringExpression value) {
            super(name);
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public void asString(StringBuilder builder) {
            this.name.asString(builder);
            builder.append("=relationship:");
            this.index.asString(builder);
            builder.append('(');
            this.key.asString(builder);
            builder.append('=');
            this.value.asString(builder);
            builder.append(')');
        }
    }

    public static class StartRelationshipsParameters
    extends StartExpression {
        public final String parameter;

        public StartRelationshipsParameters(Identifier name, String parameter) {
            super(name);
            this.parameter = parameter;
        }

        @Override
        public void asString(StringBuilder builder) {
            this.name.asString(builder);
            builder.append("=relationship({").append(this.parameter).append("})");
        }
    }

    public static class StartRelationships
    extends StartExpression {
        public final Expression[] relationships;

        public StartRelationships(Identifier name, Expression[] relationships) {
            super(name);
            this.relationships = relationships;
        }

        @Override
        public void asString(StringBuilder builder) {
            this.name.asString(builder);
            builder.append("=relationship(");
            for (int i = 0; i < this.relationships.length; ++i) {
                Expression rel = this.relationships[i];
                if (i > 0) {
                    builder.append(',');
                }
                rel.asString(builder);
            }
            builder.append(')');
        }
    }

    public static class StartNodesQueryParam
    extends StartExpression {
        public final Identifier index;
        public final String param;

        public StartNodesQueryParam(Identifier name, Identifier index, String param) {
            super(name);
            this.index = index;
            this.param = param;
        }

        @Override
        public void asString(StringBuilder builder) {
            this.name.asString(builder);
            builder.append("=node:");
            this.index.asString(builder);
            builder.append("({").append(this.param).append("})");
        }
    }

    public static class StartNodesQuery
    extends StartExpression {
        public final Identifier index;
        public final String query;

        public StartNodesQuery(Identifier name, Identifier index, String query) {
            super(name);
            this.index = index;
            this.query = query;
        }

        @Override
        public void asString(StringBuilder builder) {
            this.name.asString(builder);
            builder.append("=node:");
            this.index.asString(builder);
            builder.append("(\"").append(this.query).append("\")");
        }
    }

    public static class StartNodesLookup
    extends StartExpression {
        public final Identifier index;
        public final ReferenceExpression key;
        public final Expression value;

        public StartNodesLookup(Identifier name, Identifier index, ReferenceExpression key, Expression value) {
            super(name);
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public void asString(StringBuilder builder) {
            this.name.asString(builder);
            builder.append("=node:");
            this.index.asString(builder);
            builder.append('(');
            this.key.asString(builder);
            builder.append("=");
            this.value.asString(builder);
            builder.append(')');
        }
    }

    public static class StartNodes
    extends StartExpression {
        public final Expression[] nodes;

        public StartNodes(Identifier name, Expression[] nodes) {
            super(name);
            this.nodes = nodes;
        }

        @Override
        public void asString(StringBuilder builder) {
            this.name.asString(builder);
            builder.append("=node(");
            for (int i = 0; i < this.nodes.length; ++i) {
                Expression node = this.nodes[i];
                if (i > 0) {
                    builder.append(',');
                }
                node.asString(builder);
            }
            builder.append(')');
        }
    }

    public static class AllNodes
    extends AbstractExpression {
        @Override
        public void asString(StringBuilder builder) {
            builder.append("*");
        }
    }
}

