/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.query;

import java.io.Serializable;
import java.util.ArrayList;
import org.neo4j.cypherdsl.AsString;
import org.neo4j.cypherdsl.Literal;
import org.neo4j.cypherdsl.expression.Expression;
import org.neo4j.cypherdsl.query.clause.Clause;
import org.neo4j.cypherdsl.query.clause.WhereClause;

public class Query
implements AsString,
Serializable,
Cloneable {
    private static final String QUERY_PREFIX = "CYPHER ";
    private static final String DEFAULT_CYPHER_VERSION = "2.0";
    private final ArrayList<Clause> clauses;

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static void checkNull(Object object, String name) {
        if (object == null) {
            throw new IllegalArgumentException(name + " may not be null");
        }
        if (object.getClass().isArray()) {
            Object[] array;
            for (Object obj : array = (Object[])object) {
                if (obj != null) continue;
                throw new IllegalArgumentException(name + " may not be null");
            }
        }
    }

    public static void checkEmpty(String string, String name) {
        if (Query.isEmpty(string)) {
            throw new IllegalArgumentException(name + " may not be null or empty string");
        }
    }

    public static void checkEmpty(Expression value, String name) {
        if (value instanceof Literal && Query.isEmpty(value.toString())) {
            throw new IllegalArgumentException(name + " may not be null or empty string");
        }
    }

    public static void checkEmpty(String[] strings, String name) {
        for (String string : strings) {
            if (!Query.isEmpty(string)) continue;
            throw new IllegalArgumentException(name + " may not be null or empty string");
        }
    }

    public void add(Clause clause) {
        WhereClause previousWhere;
        if (!this.clauses.isEmpty() && clause instanceof WhereClause && (previousWhere = this.lastClause(WhereClause.class)) != null) {
            previousWhere.mergeWith((WhereClause)clause);
            return;
        }
        this.clauses.add(clause);
    }

    public <T extends Clause> T lastClause(Class<T> type) {
        Clause clause = this.clauses.get(this.clauses.size() - 1);
        return (T)(type.isInstance(clause) ? (Clause)type.cast(clause) : null);
    }

    @Override
    public void asString(StringBuilder builder) {
        this.asString(builder, DEFAULT_CYPHER_VERSION);
    }

    public void asString(StringBuilder builder, String cypherVersion) {
        builder.append(QUERY_PREFIX);
        builder.append(cypherVersion);
        for (Clause clause : this.clauses) {
            clause.asString(builder);
        }
    }

    public Query() {
        this(new ArrayList<Clause>());
    }

    private Query(ArrayList<Clause> clauses) {
        this.clauses = clauses;
    }

    public Object clone() throws CloneNotSupportedException {
        return new Query((ArrayList)this.clauses.clone());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.asString(builder);
        return builder.toString();
    }
}

