/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.querydsl;

import com.mysema.query.lucene.LuceneSerializer;
import com.mysema.query.types.Constant;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Ops;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.Visitor;
import javax.annotation.Nullable;
import org.neo4j.cypherdsl.CypherQuery;
import org.neo4j.cypherdsl.Identifier;
import org.neo4j.cypherdsl.Property;
import org.neo4j.cypherdsl.expression.BooleanExpression;
import org.neo4j.cypherdsl.expression.NumericExpression;
import org.neo4j.cypherdsl.expression.StringExpression;
import org.neo4j.cypherdsl.query.Value;

public class CypherQueryDSL
extends CypherQuery {
    private static final LuceneSerializer luceneSerializer = new LuceneSerializer(true, true);

    public static Identifier identifier(Path<?> entityPath) {
        return CypherQueryDSL.identifier(entityPath.getMetadata().getElement().toString());
    }

    public static Property property(Path<?> entityPath) {
        return CypherQueryDSL.identifier(entityPath.getRoot().toString()).property(entityPath.getMetadata().getElement().toString());
    }

    public static StringExpression string(Path<?> entityPath) {
        return CypherQueryDSL.identifier(entityPath.getRoot().toString()).string(entityPath.getMetadata().getElement().toString());
    }

    public static NumericExpression number(Path<?> entityPath) {
        return CypherQueryDSL.identifier(entityPath.getRoot().toString()).number(entityPath.getMetadata().getElement().toString());
    }

    public static String toQuery(Predicate query) {
        return luceneSerializer.toQuery((Expression)query, null).toString();
    }

    public static BooleanExpression toBooleanExpression(Predicate predicate) {
        return (BooleanExpression)predicate.accept((Visitor)new Visitor<BooleanExpression, BooleanExpression>(){

            public BooleanExpression visit(Constant<?> constant, @Nullable BooleanExpression booleanExpression) {
                return null;
            }

            public BooleanExpression visit(FactoryExpression<?> factoryExpression, @Nullable BooleanExpression booleanExpression) {
                return null;
            }

            public BooleanExpression visit(Operation<?> operation, @Nullable BooleanExpression booleanExpression) {
                String id = operation.getOperator().getId();
                if (id.equals(Ops.AND.getId())) {
                    return CypherQuery.and((BooleanExpression)operation.getArg(0).accept((Visitor)this, null), (BooleanExpression)operation.getArg(1).accept((Visitor)this, null));
                }
                if (id.equals(Ops.OR.getId())) {
                    return CypherQuery.or((BooleanExpression)operation.getArg(0).accept((Visitor)this, null), (BooleanExpression)operation.getArg(1).accept((Visitor)this, null));
                }
                if (id.equals(Ops.NOT.getId())) {
                    return CypherQuery.not((BooleanExpression)operation.getArg(0).accept((Visitor)this, null));
                }
                if (id.equals(Ops.EQ.getId())) {
                    return this.arg(operation.getArg(0)).eq(this.arg(operation.getArg(1)));
                }
                if (id.equals(Ops.NE.getId())) {
                    return this.arg(operation.getArg(0)).ne(this.arg(operation.getArg(1)));
                }
                if (id.equals(Ops.GT.getId())) {
                    return this.arg(operation.getArg(0)).gt(this.arg(operation.getArg(1)));
                }
                if (id.equals(Ops.LT.getId())) {
                    return this.arg(operation.getArg(0)).lt(this.arg(operation.getArg(1)));
                }
                if (id.equals(Ops.GOE.getId())) {
                    return this.arg(operation.getArg(0)).gte(this.arg(operation.getArg(1)));
                }
                if (id.equals(Ops.LOE.getId())) {
                    return this.arg(operation.getArg(0)).lte(this.arg(operation.getArg(1)));
                }
                if (id.equals(Ops.EXISTS.getId())) {
                    return CypherQuery.has((Property)this.arg(operation.getArg(0)));
                }
                if (id.equals(Ops.IS_NULL.getId())) {
                    return CypherQuery.isNull(this.arg(operation.getArg(0)));
                }
                if (id.equals(Ops.IS_NOT_NULL.getId())) {
                    return CypherQuery.isNotNull(this.arg(operation.getArg(0)));
                }
                if (id.equals(Ops.LIKE.getId())) {
                    return this.arg(operation.getArg(0)).regexp(this.arg(operation.getArg(1)));
                }
                throw new IllegalArgumentException("Unknown operator:" + id + " in expression " + operation);
            }

            public BooleanExpression visit(ParamExpression<?> paramExpression, @Nullable BooleanExpression booleanExpression) {
                return null;
            }

            public BooleanExpression visit(Path<?> path, @Nullable BooleanExpression booleanExpression) {
                return null;
            }

            public BooleanExpression visit(SubQueryExpression<?> subQueryExpression, @Nullable BooleanExpression booleanExpression) {
                return null;
            }

            public BooleanExpression visit(TemplateExpression<?> templateExpression, @Nullable BooleanExpression booleanExpression) {
                return null;
            }

            public Value arg(Expression expression) {
                if (expression instanceof Constant) {
                    return new Value(CypherQuery.literal(((Constant)expression).getConstant()));
                }
                if (expression instanceof ParamExpression) {
                    return new Value(CypherQuery.param(((ParamExpression)expression).getName()));
                }
                if (expression instanceof Path) {
                    Path path = (Path)expression;
                    return new Value(CypherQueryDSL.identifier(path.getRoot()).string(path.getMetadata().getElement().toString()));
                }
                throw new IllegalArgumentException("Unknown argument type:" + expression);
            }
        }, null);
    }
}

