/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.querydsl;

import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Projections;
import com.mysema.query.types.QBean;
import com.mysema.query.types.path.PathBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;

public class Projection<T> {
    private final QBean<T> bean;

    public Projection(Class<T> targetClass) {
        PathBuilder entity = new PathBuilder(targetClass, "entity");
        Field[] fields = targetClass.getFields();
        Expression[] fieldExpressions = new Expression[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldExpressions[i] = entity.getString(fields[i].getName());
        }
        this.bean = Projections.fields(targetClass, (Expression[])fieldExpressions);
    }

    public Iterable<T> iterable(Iterable<Map<String, Object>> result) {
        ArrayList<Object> entities = new ArrayList<Object>();
        for (Map<String, Object> stringObjectMap : result) {
            Object[] args = new Object[stringObjectMap.size()];
            int idx = 0;
            for (Expression expression : this.bean.getArgs()) {
                args[idx++] = stringObjectMap.get(((Path)expression).getMetadata().getElement().toString());
            }
            entities.add(this.bean.newInstance(args));
        }
        return entities;
    }
}

