/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation;

import java.io.Serializable;
import org.neo4j.cypher.internal.runtime.ExecutionContext;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.AggregationFunction;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression$AggregatingDurations$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression$AggregatingNumbers$;
import org.neo4j.exceptions.InternalException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.utils.ValueMath;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001'\tY1+^7Gk:\u001cG/[8o\u0015\t\u0019A!A\u0006bO\u001e\u0014XmZ1uS>t'BA\u0003\u0007\u0003\u0015\u0001\u0018\u000e]3t\u0015\t9\u0001\"A\u0006j]R,'\u000f\u001d:fi\u0016$'BA\u0005\u000b\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0003\u0007\u0002\u0011%tG/\u001a:oC2T!!\u0004\b\u0002\r\rL\b\u000f[3s\u0015\ty\u0001#A\u0003oK>$$NC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\r\u0001A\u0003\u0007\t\u0003+Yi\u0011AA\u0005\u0003/\t\u00111#Q4he\u0016<\u0017\r^5p]\u001a+hn\u0019;j_:\u0004\"!F\r\n\u0005i\u0011!A\n(v[\u0016\u0014\u0018nY(s\tV\u0014\u0018\r^5p]\u0006;wM]3hCRLwN\\#yaJ,7o]5p]\"AA\u0004\u0001BC\u0002\u0013\u0005Q$A\u0003wC2,X-F\u0001\u001f!\tyB%D\u0001!\u0015\t\t#%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0012\u0007\u0003!\u0019w.\\7b]\u0012\u001c\u0018BA\u0013!\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tO\u0001\u0011\t\u0011)A\u0005=\u00051a/\u00197vK\u0002BQ!\u000b\u0001\u0005\u0002)\na\u0001P5oSRtDCA\u0016-!\t)\u0002\u0001C\u0003\u001dQ\u0001\u0007a\u0004C\u0003/\u0001\u0011\u0005q&\u0001\u0003oC6,W#\u0001\u0019\u0011\u0005E2T\"\u0001\u001a\u000b\u0005M\"\u0014\u0001\u00027b]\u001eT\u0011!N\u0001\u0005U\u00064\u0018-\u0003\u00028e\t11\u000b\u001e:j]\u001eDQ!\u000f\u0001\u0005Bi\naA]3tk2$HCA\u001eB!\tat(D\u0001>\u0015\tqd\"\u0001\u0004wC2,Xm]\u0005\u0003\u0001v\u0012\u0001\"\u00118z-\u0006dW/\u001a\u0005\u0006\u0005b\u0002\raQ\u0001\u0006gR\fG/\u001a\t\u0003\t\u0016k\u0011\u0001B\u0005\u0003\r\u0012\u0011!\"U;fef\u001cF/\u0019;f\u0011\u0015A\u0005\u0001\"\u0011J\u0003\u0015\t\u0007\u000f\u001d7z)\rQ\u0005K\u0016\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0002\u001b\u0006)1oY1mC&\u0011q\n\u0014\u0002\u0005+:LG\u000fC\u0003R\u000f\u0002\u0007!+\u0001\u0003eCR\f\u0007CA*U\u001b\u0005A\u0011BA+\t\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0003C\u000f\u0002\u00071\t")
public class SumFunction
extends AggregationFunction
implements NumericOrDurationAggregationExpression {
    private final Expression value;
    private volatile NumericOrDurationAggregationExpression$AggregatingNumbers$ AggregatingNumbers$module;
    private volatile NumericOrDurationAggregationExpression$AggregatingDurations$ AggregatingDurations$module;
    private NumberValue sumNumber;
    private DurationValue sumDuration;
    private Option<NumericOrDurationAggregationExpression.AggregatingType> aggregatingType;

    @Override
    public void actOnNumberOrDuration(AnyValue vl, Function1<NumberValue, BoxedUnit> aggNumber, Function1<DurationValue, BoxedUnit> aggDuration) {
        NumericOrDurationAggregationExpression.actOnNumberOrDuration$(this, vl, aggNumber, aggDuration);
    }

    @Override
    public NumericOrDurationAggregationExpression$AggregatingNumbers$ AggregatingNumbers() {
        if (this.AggregatingNumbers$module == null) {
            this.AggregatingNumbers$lzycompute$1();
        }
        return this.AggregatingNumbers$module;
    }

    @Override
    public NumericOrDurationAggregationExpression$AggregatingDurations$ AggregatingDurations() {
        if (this.AggregatingDurations$module == null) {
            this.AggregatingDurations$lzycompute$1();
        }
        return this.AggregatingDurations$module;
    }

    @Override
    public NumberValue sumNumber() {
        return this.sumNumber;
    }

    @Override
    public void sumNumber_$eq(NumberValue x$1) {
        this.sumNumber = x$1;
    }

    @Override
    public DurationValue sumDuration() {
        return this.sumDuration;
    }

    @Override
    public void sumDuration_$eq(DurationValue x$1) {
        this.sumDuration = x$1;
    }

    @Override
    public Option<NumericOrDurationAggregationExpression.AggregatingType> aggregatingType() {
        return this.aggregatingType;
    }

    @Override
    public void aggregatingType_$eq(Option<NumericOrDurationAggregationExpression.AggregatingType> x$1) {
        this.aggregatingType = x$1;
    }

    @Override
    public Expression value() {
        return this.value;
    }

    @Override
    public String name() {
        return "SUM";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AnyValue result(QueryState state) {
        boolean bl = false;
        Some some = null;
        Option<NumericOrDurationAggregationExpression.AggregatingType> option = this.aggregatingType();
        if (None$.MODULE$.equals(option)) {
            return this.sumNumber();
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            NumericOrDurationAggregationExpression.AggregatingType aggregatingType = (NumericOrDurationAggregationExpression.AggregatingType)some.value();
            if (this.AggregatingNumbers().equals(aggregatingType)) {
                return this.sumNumber();
            }
        }
        if (!bl) throw new InternalException(new StringBuilder(25).append("invalid aggregation type ").append(this.aggregatingType()).toString());
        NumericOrDurationAggregationExpression.AggregatingType aggregatingType = (NumericOrDurationAggregationExpression.AggregatingType)some.value();
        if (!this.AggregatingDurations().equals(aggregatingType)) throw new InternalException(new StringBuilder(25).append("invalid aggregation type ").append(this.aggregatingType()).toString());
        return this.sumDuration();
    }

    @Override
    public void apply(ExecutionContext data, QueryState state) {
        AnyValue vl = this.value().apply(data, state);
        this.actOnNumberOrDuration(vl, (Function1<NumberValue, BoxedUnit>)(Function1 & Serializable & scala.Serializable)number -> {
            this.sumNumber_$eq(ValueMath.overflowSafeAdd((NumberValue)this.sumNumber(), (NumberValue)number));
            return BoxedUnit.UNIT;
        }, (Function1<DurationValue, BoxedUnit>)(Function1 & Serializable & scala.Serializable)duration -> {
            this.sumDuration_$eq(this.sumDuration().add(duration));
            return BoxedUnit.UNIT;
        });
    }

    private final void AggregatingNumbers$lzycompute$1() {
        SumFunction sumFunction = this;
        synchronized (sumFunction) {
            if (this.AggregatingNumbers$module == null) {
                this.AggregatingNumbers$module = new NumericOrDurationAggregationExpression$AggregatingNumbers$(this);
            }
        }
    }

    private final void AggregatingDurations$lzycompute$1() {
        SumFunction sumFunction = this;
        synchronized (sumFunction) {
            if (this.AggregatingDurations$module == null) {
                this.AggregatingDurations$module = new NumericOrDurationAggregationExpression$AggregatingDurations$(this);
            }
        }
    }

    public SumFunction(Expression value) {
        this.value = value;
        NumericOrDurationAggregationExpression.$init$(this);
    }
}

