/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.kernel.impl.util.NodeEntityWrappingNodeValue;
import org.neo4j.kernel.impl.util.RelationshipEntityWrappingValue;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;

public final class ValuePopulation {
    private ValuePopulation() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static AnyValue populate(AnyValue value, NodeCursor nodeCursor, RelationshipScanCursor relCursor, PropertyCursor propertyCursor) {
        if (value instanceof NodeEntityWrappingNodeValue) {
            ((NodeEntityWrappingNodeValue)value).populate(nodeCursor, propertyCursor);
        } else if (value instanceof RelationshipEntityWrappingValue) {
            ((RelationshipEntityWrappingValue)value).populate(relCursor, propertyCursor);
        } else if (value instanceof PathValue) {
            PathValue path = (PathValue)value;
            for (NodeValue nodeValue : path.nodes()) {
                ValuePopulation.populate(nodeValue, nodeCursor, propertyCursor);
            }
            for (NodeValue nodeValue : path.relationships()) {
                ValuePopulation.populate((RelationshipValue)nodeValue, relCursor, propertyCursor);
            }
        } else if (value instanceof ListValue) {
            for (AnyValue v : (ListValue)value) {
                ValuePopulation.populate(v, nodeCursor, relCursor, propertyCursor);
            }
        } else if (value instanceof MapValue) {
            ((MapValue)value).foreach((ignore, anyValue) -> ValuePopulation.populate(anyValue, nodeCursor, relCursor, propertyCursor));
        }
        return value;
    }

    public static NodeValue populate(NodeValue value, NodeCursor nodeCursor, PropertyCursor propertyCursor) {
        if (value instanceof NodeEntityWrappingNodeValue) {
            ((NodeEntityWrappingNodeValue)value).populate(nodeCursor, propertyCursor);
        }
        return value;
    }

    public static RelationshipValue populate(RelationshipValue value, RelationshipScanCursor relCursor, PropertyCursor propertyCursor) {
        if (value instanceof RelationshipEntityWrappingValue) {
            ((RelationshipEntityWrappingValue)value).populate(relCursor, propertyCursor);
        }
        return value;
    }
}

