/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import java.util.ArrayList;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.core.TransactionalEntityFactory;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.NodeReference;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipReference;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public final class CompiledMaterializeValueMapper {
    public static AnyValue mapAnyValue(TransactionalEntityFactory proxySPI, AnyValue value) {
        DryRunMaterializeValueMapper dryRunMapper = new DryRunMaterializeValueMapper();
        value.map((ValueMapper)dryRunMapper);
        if (dryRunMapper.needsConversion) {
            WritingMaterializeValueMapper realMapper = new WritingMaterializeValueMapper(proxySPI);
            return (AnyValue)value.map((ValueMapper)realMapper);
        }
        return value;
    }

    static abstract class AbstractMaterializeValueMapper
    implements ValueMapper<AnyValue> {
        AbstractMaterializeValueMapper() {
        }

        public AnyValue mapPath(PathValue value) {
            return value;
        }

        public AnyValue mapNoValue() {
            return Values.NO_VALUE;
        }

        public AnyValue mapText(TextValue value) {
            return value;
        }

        public AnyValue mapBoolean(BooleanValue value) {
            return value;
        }

        public AnyValue mapNumber(NumberValue value) {
            return value;
        }

        public AnyValue mapDateTime(DateTimeValue value) {
            return value;
        }

        public AnyValue mapLocalDateTime(LocalDateTimeValue value) {
            return value;
        }

        public AnyValue mapDate(DateValue value) {
            return value;
        }

        public AnyValue mapTime(TimeValue value) {
            return value;
        }

        public AnyValue mapLocalTime(LocalTimeValue value) {
            return value;
        }

        public AnyValue mapDuration(DurationValue value) {
            return value;
        }

        public AnyValue mapPoint(PointValue value) {
            return value;
        }
    }

    private static final class DryRunMaterializeValueMapper
    extends AbstractMaterializeValueMapper {
        boolean needsConversion;

        private DryRunMaterializeValueMapper() {
        }

        public AnyValue mapNode(VirtualNodeValue value) {
            if (!this.needsConversion) {
                this.needsConversion = value instanceof NodeReference;
            }
            return value;
        }

        public AnyValue mapRelationship(VirtualRelationshipValue value) {
            if (!this.needsConversion) {
                this.needsConversion = value instanceof RelationshipReference;
            }
            return value;
        }

        public AnyValue mapMap(MapValue value) {
            value.foreach((k, v) -> v.map((ValueMapper)this));
            return value;
        }

        public AnyValue mapSequence(SequenceValue value) {
            value.forEach(v -> v.map((ValueMapper)this));
            return (AnyValue)value;
        }
    }

    private static final class WritingMaterializeValueMapper
    extends AbstractMaterializeValueMapper {
        private final TransactionalEntityFactory proxySpi;

        WritingMaterializeValueMapper(TransactionalEntityFactory proxySpi) {
            this.proxySpi = proxySpi;
        }

        public AnyValue mapNode(VirtualNodeValue value) {
            if (value instanceof NodeValue) {
                return value;
            }
            return ValueUtils.fromNodeEntity((Node)this.proxySpi.newNodeEntity(value.id()));
        }

        public AnyValue mapRelationship(VirtualRelationshipValue value) {
            if (value instanceof RelationshipValue) {
                return value;
            }
            return ValueUtils.fromRelationshipEntity((Relationship)this.proxySpi.newRelationshipEntity(value.id()));
        }

        public AnyValue mapMap(MapValue value) {
            MapValueBuilder builder = new MapValueBuilder();
            value.foreach((k, v) -> builder.add(k, (AnyValue)v.map((ValueMapper)this)));
            return builder.build();
        }

        public AnyValue mapSequence(SequenceValue value) {
            ArrayList list = new ArrayList(value.length());
            value.forEach(v -> list.add((AnyValue)v.map((ValueMapper)this)));
            return VirtualValues.fromList(list);
        }
    }
}

