/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.internal.collector.ActionResult;
import org.neo4j.internal.collector.Anonymizer;
import org.neo4j.internal.collector.CollectorStateMachine;
import org.neo4j.internal.collector.DataCollector;
import org.neo4j.internal.collector.GraphCountsSection;
import org.neo4j.internal.collector.IdAnonymizer;
import org.neo4j.internal.collector.MetaSection;
import org.neo4j.internal.collector.PlainText;
import org.neo4j.internal.collector.QueriesSection;
import org.neo4j.internal.collector.QueryCollector;
import org.neo4j.internal.collector.RetrieveConfig;
import org.neo4j.internal.collector.RetrieveResult;
import org.neo4j.internal.collector.Sections;
import org.neo4j.internal.collector.StatusResult;
import org.neo4j.internal.collector.TokensSection;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.procedure.SystemProcedure;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.values.ValueMapper;

public class DataCollectorProcedures {
    @Context
    public DataCollector dataCollector;
    @Context
    public KernelTransaction transaction;
    @Context
    public ProcedureCallContext callContext;
    @Context
    public ValueMapper valueMapper;

    @Admin
    @SystemProcedure
    @Description(value="Retrieve statistical data about the current database. Valid sections are 'GRAPH COUNTS', 'TOKENS', 'QUERIES', 'META'")
    @Procedure(name="db.stats.retrieve", mode=Mode.READ)
    public Stream<RetrieveResult> retrieve(@Name(value="section") String section, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws InvalidArgumentsException, IndexNotFoundKernelException, TransactionFailureException {
        String upperSection;
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        switch (upperSection = section.toUpperCase()) {
            case "GRAPH COUNTS": {
                return GraphCountsSection.retrieve(this.dataCollector.getKernel(), Anonymizer.PLAIN_TEXT);
            }
            case "TOKENS": {
                return TokensSection.retrieve(this.dataCollector.getKernel());
            }
            case "META": {
                return MetaSection.retrieve(null, this.dataCollector.getKernel(), this.dataCollector.getQueryCollector().numSilentQueryDrops());
            }
            case "QUERIES": {
                return QueriesSection.retrieve((Iterator)this.dataCollector.getQueryCollector().getData(), new PlainText((ValueMapper.JavaMapper)this.valueMapper), RetrieveConfig.of(config).maxInvocations);
            }
        }
        throw Sections.unknownSectionException(section);
    }

    @Admin
    @SystemProcedure
    @Description(value="Retrieve all available statistical data about the current database, in an anonymized form.")
    @Procedure(name="db.stats.retrieveAllAnonymized", mode=Mode.READ)
    public Stream<RetrieveResult> retrieveAllAnonymized(@Name(value="graphToken") String graphToken, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws IndexNotFoundKernelException, TransactionFailureException, InvalidArgumentsException {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        if (graphToken == null || graphToken.equals("")) {
            throw new InvalidArgumentsException("Graph token must be a non-empty string");
        }
        return Stream.of(MetaSection.retrieve(graphToken, this.dataCollector.getKernel(), this.dataCollector.getQueryCollector().numSilentQueryDrops()), GraphCountsSection.retrieve(this.dataCollector.getKernel(), Anonymizer.IDS), QueriesSection.retrieve((Iterator)this.dataCollector.getQueryCollector().getData(), new IdAnonymizer(this.transaction.tokenRead()), RetrieveConfig.of(config).maxInvocations)).flatMap(x -> x);
    }

    @Admin
    @SystemProcedure
    @Description(value="Retrieve the status of all available collector daemons, for this database.")
    @Procedure(name="db.stats.status", mode=Mode.READ)
    public Stream<StatusResult> status() {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        CollectorStateMachine.Status status = this.dataCollector.getQueryCollector().status();
        return Stream.of(new StatusResult("QUERIES", status.message, Collections.emptyMap()));
    }

    @Admin
    @SystemProcedure
    @Description(value="Start data collection of a given data section. Valid sections are 'QUERIES'")
    @Procedure(name="db.stats.collect", mode=Mode.READ)
    public Stream<ActionResult> collect(@Name(value="section") String section, @Name(value="config", defaultValue="{}") Map<String, Object> config) throws InvalidArgumentsException {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        CollectorStateMachine.Result result = this.collectorStateMachine(section).collect(config);
        return Stream.of(new ActionResult(section, result.success, result.message));
    }

    @Admin
    @SystemProcedure
    @Description(value="Stop data collection of a given data section. Valid sections are 'QUERIES'")
    @Procedure(name="db.stats.stop", mode=Mode.READ)
    public Stream<ActionResult> stop(@Name(value="section") String section) throws InvalidArgumentsException {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        CollectorStateMachine.Result result = this.collectorStateMachine(section).stop(Long.MAX_VALUE);
        return Stream.of(new ActionResult(section, result.success, result.message));
    }

    @Admin
    @SystemProcedure
    @Description(value="Clear collected data of a given data section. Valid sections are 'QUERIES'")
    @Procedure(name="db.stats.clear", mode=Mode.READ)
    public Stream<ActionResult> clear(@Name(value="section") String section) throws InvalidArgumentsException {
        if (this.callContext.isSystemDatabase()) {
            return Stream.empty();
        }
        CollectorStateMachine.Result result = this.collectorStateMachine(section).clear();
        return Stream.of(new ActionResult(section, result.success, result.message));
    }

    private QueryCollector collectorStateMachine(String section) throws InvalidArgumentsException {
        switch (section) {
            case "TOKENS": 
            case "GRAPH COUNTS": {
                throw new InvalidArgumentsException("Section '%s' does not have to be explicitly collected, it can always be directly retrieved.");
            }
            case "QUERIES": {
                return this.dataCollector.getQueryCollector();
            }
        }
        throw Sections.unknownSectionException(section);
    }
}

