/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.neo4j.helpers.collection.PrefetchingIterator;

public class CsvFileReader
extends PrefetchingIterator<String[]> {
    private final BufferedReader reader;
    private String delimiter;

    public CsvFileReader(File file) throws IOException {
        this(file, null);
    }

    public CsvFileReader(File file, String delimiter) throws IOException {
        this.delimiter = delimiter;
        this.reader = new BufferedReader(new FileReader(file));
    }

    protected String[] fetchNextOrNull() {
        try {
            String line = this.reader.readLine();
            if (line == null) {
                this.close();
                return null;
            }
            if (this.delimiter == null) {
                this.delimiter = this.figureOutDelimiter(line);
            }
            return line.split(this.delimiter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String figureOutDelimiter(String line) {
        String[] candidates;
        for (String candidate : candidates = new String[]{"\t", ","}) {
            if (line.indexOf(candidate) <= -1) continue;
            return candidate;
        }
        throw new RuntimeException("Couldn't guess delimiter in '" + line + "'");
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

