/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality;

import common.Neo4jAlgoTestCase;
import java.util.Comparator;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.CostAccumulator;
import org.neo4j.graphalgo.impl.centrality.Eccentricity;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPath;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPathDijkstra;
import org.neo4j.graphalgo.impl.util.DoubleAdder;
import org.neo4j.graphalgo.impl.util.DoubleComparator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.RelationshipType;

public class EccentricityTest
extends Neo4jAlgoTestCase {
    protected SingleSourceShortestPath<Double> getSingleSourceShortestPath() {
        return new SingleSourceShortestPathDijkstra((Object)0.0, null, (relationship, direction) -> 1.0, (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Direction.BOTH, new RelationshipType[]{Neo4jAlgoTestCase.MyRelTypes.R1});
    }

    Eccentricity<Double> getCentralityAlgorithm() {
        return new Eccentricity(this.getSingleSourceShortestPath(), (Object)0.0, graph.getAllNodes(), (Comparator)new DoubleComparator());
    }

    protected void assertCentrality(Eccentricity<Double> centrality, String nodeId, Double value) {
        Assert.assertTrue((boolean)((Double)centrality.getCentrality(graph.getNode(nodeId))).equals(value));
    }

    @Test
    public void testBox() {
        graph.makeEdgeChain("a,b,c,d,a");
        Eccentricity<Double> centrality = this.getCentralityAlgorithm();
        this.assertCentrality(centrality, "a", 2.0);
        this.assertCentrality(centrality, "b", 2.0);
        this.assertCentrality(centrality, "c", 2.0);
        this.assertCentrality(centrality, "d", 2.0);
    }

    @Test
    public void testPlusShape() {
        graph.makeEdgeChain("a,b,c");
        graph.makeEdgeChain("d,b,e");
        Eccentricity<Double> centrality = this.getCentralityAlgorithm();
        this.assertCentrality(centrality, "a", 2.0);
        this.assertCentrality(centrality, "b", 1.0);
        this.assertCentrality(centrality, "c", 2.0);
        this.assertCentrality(centrality, "d", 2.0);
        this.assertCentrality(centrality, "e", 2.0);
    }

    @Test
    public void testChain() {
        graph.makeEdgeChain("a,b,c,d,e");
        Eccentricity<Double> centrality = this.getCentralityAlgorithm();
        this.assertCentrality(centrality, "a", 4.0);
        this.assertCentrality(centrality, "b", 3.0);
        this.assertCentrality(centrality, "c", 2.0);
        this.assertCentrality(centrality, "d", 3.0);
        this.assertCentrality(centrality, "e", 4.0);
    }
}

