/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality;

import common.Neo4jAlgoTestCase;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.CommonEvaluators;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.impl.centrality.EigenvectorCentrality;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public abstract class EigenvectorCentralityTest
extends Neo4jAlgoTestCase {
    @Test
    public void shouldHandleTargetNodeBeingOrphan() {
        graph.makeNode("o");
        EigenvectorCentrality eigenvectorCentrality = this.getEigenvectorCentrality(Direction.BOTH, (CostEvaluator<Double>)((CostEvaluator)(relationship, direction) -> 1.0), graph.getAllNodes(), graph.getAllEdges(), 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "o", 0.0, 0.02);
    }

    @Test
    public void shouldHandleFirstNodeBeingOrphan() {
        Node orphan = graph.makeNode("o");
        Node a = graph.makeNode("a");
        Node b = graph.makeNode("b");
        Node c = graph.makeNode("c");
        Node d = graph.makeNode("d");
        HashSet<Node> nodeSet = new HashSet<Node>();
        nodeSet.add(orphan);
        nodeSet.add(a);
        nodeSet.add(b);
        nodeSet.add(c);
        nodeSet.add(d);
        HashSet<Relationship> relSet = new HashSet<Relationship>();
        relSet.add(graph.makeEdge("a", "b"));
        relSet.add(graph.makeEdge("b", "c"));
        relSet.add(graph.makeEdge("c", "d"));
        relSet.add(graph.makeEdge("d", "c"));
        relSet.add(graph.makeEdge("c", "a"));
        EigenvectorCentrality eigenvectorCentrality = this.getEigenvectorCentrality(Direction.OUTGOING, (CostEvaluator<Double>)((CostEvaluator)(relationship, direction) -> 1.0), nodeSet, relSet, 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "o", 0.0, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "a", 0.481, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "b", 0.363, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "c", 0.637, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "d", 0.481, 0.02);
    }

    @Test
    public void shouldHandleFirstNodeBeingOrphanInRelationshipSet() {
        Node orphan = graph.makeNode("o");
        Node a = graph.makeNode("a");
        Node b = graph.makeNode("b");
        Node c = graph.makeNode("c");
        Node d = graph.makeNode("d");
        HashSet<Node> nodeSet = new HashSet<Node>();
        nodeSet.add(orphan);
        nodeSet.add(a);
        nodeSet.add(b);
        nodeSet.add(c);
        nodeSet.add(d);
        HashSet<Relationship> relSet = new HashSet<Relationship>();
        relSet.add(graph.makeEdge("a", "b"));
        relSet.add(graph.makeEdge("b", "c"));
        relSet.add(graph.makeEdge("c", "d"));
        relSet.add(graph.makeEdge("d", "c"));
        relSet.add(graph.makeEdge("c", "a"));
        graph.makeEdge("a", "o");
        EigenvectorCentrality eigenvectorCentrality = this.getEigenvectorCentrality(Direction.OUTGOING, (CostEvaluator<Double>)((CostEvaluator)(relationship, direction) -> 1.0), nodeSet, relSet, 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "o", 0.0, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "a", 0.481, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "b", 0.363, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "c", 0.637, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "d", 0.481, 0.02);
    }

    @Test
    public void simpleTest() {
        graph.makeEdgeChain("a,b,c,d");
        graph.makeEdges("b,a,c,a");
        EigenvectorCentrality eigenvectorCentrality = this.getEigenvectorCentrality(Direction.OUTGOING, (CostEvaluator<Double>)((CostEvaluator)(relationship, direction) -> 1.0), graph.getAllNodes(), graph.getAllEdges(), 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "a", 0.693, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "b", 0.523, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "c", 0.395, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "d", 0.298, 0.02);
    }

    @Test
    public void testDirection() {
        graph.makeEdgeChain("d,c,b,a");
        graph.makeEdges("a,b,a,c");
        EigenvectorCentrality eigenvectorCentrality = this.getEigenvectorCentrality(Direction.INCOMING, (CostEvaluator<Double>)((CostEvaluator)(relationship, direction) -> 1.0), graph.getAllNodes(), graph.getAllEdges(), 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "a", 0.693, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "b", 0.523, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "c", 0.395, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "d", 0.298, 0.02);
    }

    @Test
    public void shouldHandleIsolatedCommunities() {
        HashSet<Node> nodeSet = new HashSet<Node>();
        nodeSet.add(graph.makeNode("a"));
        nodeSet.add(graph.makeNode("b"));
        nodeSet.add(graph.makeNode("c"));
        nodeSet.add(graph.makeNode("d"));
        nodeSet.add(graph.makeNode("e"));
        nodeSet.add(graph.makeNode("f"));
        HashSet<Relationship> relSet = new HashSet<Relationship>();
        relSet.add(graph.makeEdge("a", "b"));
        relSet.add(graph.makeEdge("c", "d"));
        relSet.add(graph.makeEdge("d", "e"));
        relSet.add(graph.makeEdge("e", "f"));
        relSet.add(graph.makeEdge("e", "c"));
        relSet.add(graph.makeEdge("f", "e"));
        EigenvectorCentrality eigenvectorCentrality = this.getEigenvectorCentrality(Direction.OUTGOING, (CostEvaluator<Double>)((CostEvaluator)(relationship, direction) -> 1.0), nodeSet, relSet, 0.001);
        this.assertApproximateCentrality(eigenvectorCentrality, "a", 0.0, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "b", 0.0, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "c", 0.48, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "d", 0.36, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "e", 0.64, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "f", 0.48, 0.02);
    }

    @Test
    public void testWeight() {
        graph.makeEdgeChain("a,b", "cost", 1.0);
        graph.makeEdgeChain("b,c", "cost", 1.0);
        graph.makeEdgeChain("c,d", "cost", 1.0);
        graph.makeEdgeChain("c,b", "cost", 0.1);
        graph.makeEdgeChain("c,a", "cost", 0.1);
        EigenvectorCentrality eigenvectorCentrality = this.getEigenvectorCentrality(Direction.OUTGOING, (CostEvaluator<Double>)CommonEvaluators.doubleCostEvaluator((String)"cost"), graph.getAllNodes(), graph.getAllEdges(), 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "a", 0.0851, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "b", 0.244, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "c", 0.456, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "d", 0.852, 0.02);
    }

    @Test
    public void testWeightAndDirection() {
        graph.makeEdgeChain("a,b");
        graph.makeEdgeChain("b,c");
        graph.makeEdgeChain("c,d");
        graph.makeEdgeChain("c,a");
        HashMap<String, Double> costs = new HashMap<String, Double>();
        costs.put("a,b", 1.0);
        costs.put("b,c", 1.0);
        costs.put("c,d", 1.0);
        costs.put("c,b", 0.1);
        costs.put("c,a", 0.1);
        EigenvectorCentrality eigenvectorCentrality = this.getEigenvectorCentrality(Direction.BOTH, (CostEvaluator<Double>)((CostEvaluator)(relationship, direction) -> {
            Double value;
            String start = graph.getNodeId(relationship.getStartNode());
            String end = graph.getNodeId(relationship.getEndNode());
            if (direction == Direction.INCOMING) {
                String tmp = end;
                end = start;
                start = tmp;
            }
            if ((value = (Double)costs.get(start + "," + end)) == null) {
                return 0.0;
            }
            return value;
        }), graph.getAllNodes(), graph.getAllEdges(), 0.01);
        this.assertApproximateCentrality(eigenvectorCentrality, "a", 0.0851, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "b", 0.244, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "c", 0.456, 0.02);
        this.assertApproximateCentrality(eigenvectorCentrality, "d", 0.852, 0.02);
    }

    protected void assertApproximateCentrality(EigenvectorCentrality eigenvectorCentrality, String nodeId, Double value, Double precision) {
        Double centrality = eigenvectorCentrality.getCentrality(graph.getNode(nodeId));
        Assert.assertEquals((double)value, (double)centrality, (double)precision);
    }

    protected abstract EigenvectorCentrality getEigenvectorCentrality(Direction var1, CostEvaluator<Double> var2, Set<Node> var3, Set<Relationship> var4, double var5);
}

