/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality;

import common.Neo4jAlgoTestCase;
import java.util.Comparator;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.CostAccumulator;
import org.neo4j.graphalgo.impl.centrality.StressCentrality;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPath;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPathDijkstra;
import org.neo4j.graphalgo.impl.util.DoubleAdder;
import org.neo4j.graphalgo.impl.util.DoubleComparator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;

public class StressCentralityTest
extends Neo4jAlgoTestCase {
    protected SingleSourceShortestPath<Double> getSingleSourceShortestPath() {
        return new SingleSourceShortestPathDijkstra((Object)0.0, null, (relationship, direction) -> 1.0, (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Direction.BOTH, new RelationshipType[]{Neo4jAlgoTestCase.MyRelTypes.R1});
    }

    protected void assertCentrality(StressCentrality<Double> stressCentrality, String nodeId, Double value) {
        Assert.assertTrue((boolean)((Double)stressCentrality.getCentrality(graph.getNode(nodeId))).equals(value));
    }

    @Test
    public void testBox() {
        graph.makeEdgeChain("a,b,c,d,a");
        StressCentrality stressCentrality = new StressCentrality(this.getSingleSourceShortestPath(), graph.getAllNodes());
        stressCentrality.calculate();
        this.assertCentrality((StressCentrality<Double>)stressCentrality, "a", 1.0);
        this.assertCentrality((StressCentrality<Double>)stressCentrality, "b", 1.0);
        this.assertCentrality((StressCentrality<Double>)stressCentrality, "c", 1.0);
        this.assertCentrality((StressCentrality<Double>)stressCentrality, "d", 1.0);
    }

    @Test
    public void testPlusShape() {
        graph.makeEdgeChain("a,b,c");
        graph.makeEdgeChain("d,b,e");
        StressCentrality stressCentrality = new StressCentrality(this.getSingleSourceShortestPath(), graph.getAllNodes());
        stressCentrality.calculate();
        this.assertCentrality((StressCentrality<Double>)stressCentrality, "a", 0.0);
        this.assertCentrality((StressCentrality<Double>)stressCentrality, "b", 6.0);
        this.assertCentrality((StressCentrality<Double>)stressCentrality, "c", 0.0);
        this.assertCentrality((StressCentrality<Double>)stressCentrality, "d", 0.0);
        this.assertCentrality((StressCentrality<Double>)stressCentrality, "e", 0.0);
    }

    @Test
    public void testChain() {
        graph.makeEdgeChain("a,b,c,d,e");
        StressCentrality stressCentrality = new StressCentrality(this.getSingleSourceShortestPath(), graph.getAllNodes());
        stressCentrality.calculate();
        this.assertCentrality((StressCentrality<Double>)stressCentrality, "a", 0.0);
        this.assertCentrality((StressCentrality<Double>)stressCentrality, "b", 3.0);
        this.assertCentrality((StressCentrality<Double>)stressCentrality, "c", 4.0);
        this.assertCentrality((StressCentrality<Double>)stressCentrality, "d", 3.0);
        this.assertCentrality((StressCentrality<Double>)stressCentrality, "e", 0.0);
    }

    @Test
    public void testStressUpdating() {
        graph.makeEdgeChain("a,b,c,d,e,f");
        new StressTest(this.getSingleSourceShortestPath(), graph.getAllNodes()).test();
    }

    class StressTest
    extends StressCentrality<Double> {
        StressTest(SingleSourceShortestPath<Double> singleSourceShortestPath, Set<Node> nodeSet) {
            super(singleSourceShortestPath, nodeSet);
        }

        public void test() {
            this.doneCalculation = true;
            Node startNode = graph.getNode("c");
            this.singleSourceShortestPath.reset();
            this.singleSourceShortestPath.setStartNode(startNode);
            this.processShortestPaths(startNode, this.singleSourceShortestPath);
            Double adjustment = 0.5;
            StressCentralityTest.this.assertCentrality(this, "a", 0.0 * adjustment);
            StressCentralityTest.this.assertCentrality(this, "b", 1.0 * adjustment);
            StressCentralityTest.this.assertCentrality(this, "c", 0.0 * adjustment);
            StressCentralityTest.this.assertCentrality(this, "d", 2.0 * adjustment);
            StressCentralityTest.this.assertCentrality(this, "e", 1.0 * adjustment);
            StressCentralityTest.this.assertCentrality(this, "f", 0.0 * adjustment);
        }
    }
}

