/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import common.Neo4jAlgoTestCase;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphalgo.CommonEvaluators;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.impl.util.BestFirstSelectorFactory;
import org.neo4j.graphalgo.impl.util.PathInterest;
import org.neo4j.graphalgo.impl.util.PathInterestFactory;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.kernel.impl.traversal.MonoDirectionalTraversalDescription;

@RunWith(value=Parameterized.class)
public class TestBestFirstSelectorFactory
extends Neo4jAlgoTestCase {
    private final String length = "length";
    private final PathExpander expander;
    private final Uniqueness uniqueness;
    private final String[] expectedResult;
    private final BestFirstSelectorFactory<Integer, Integer> factory;

    @Before
    public void buildGraph() {
        graph.makePathWithRelProperty("length", "a-1-b-2-d");
        graph.makePathWithRelProperty("length", "a-2-c-4-b");
    }

    @Test
    public void shouldDoWholeTraversalInCorrectOrder() {
        Node a = graph.getNode("a");
        Traverser traverser = new MonoDirectionalTraversalDescription().expand(this.expander).order(this.factory).uniqueness((UniquenessFactory)this.uniqueness).traverse(a);
        ResourceIterator iterator = traverser.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            this.assertPath((Path)iterator.next(), this.expectedResult[i]);
            ++i;
        }
        Assert.assertEquals((String)String.format("Not all expected paths where traversed. Missing paths are %s\n", Arrays.toString(Arrays.copyOfRange(this.expectedResult, i, this.expectedResult.length))), (long)this.expectedResult.length, (long)i);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({PathExpanders.allTypesAndDirections(), PathInterestFactory.all(), Uniqueness.NODE_PATH, new String[]{"a", "a,b", "a,c", "a,b,d", "a,b,c", "a,c,b", "a,c,b,d"}}, {PathExpanders.allTypesAndDirections(), PathInterestFactory.allShortest(), Uniqueness.NODE_PATH, new String[]{"a", "a,b", "a,c", "a,b,d"}}, {PathExpanders.forDirection((Direction)Direction.OUTGOING), PathInterestFactory.all(), Uniqueness.NODE_PATH, new String[]{"a", "a,b", "a,c", "a,b,d", "a,c,b", "a,c,b,d"}}, {PathExpanders.allTypesAndDirections(), PathInterestFactory.all(), Uniqueness.NODE_GLOBAL, new String[]{"a", "a,b", "a,c", "a,b,d"}}, {PathExpanders.allTypesAndDirections(), PathInterestFactory.all(), Uniqueness.RELATIONSHIP_GLOBAL, new String[]{"a", "a,b", "a,c", "a,b,d", "a,b,c"}});
    }

    public TestBestFirstSelectorFactory(PathExpander expander, PathInterest<Integer> interest, Uniqueness uniqueness, String[] expectedResult) {
        this.expander = expander;
        this.uniqueness = uniqueness;
        this.expectedResult = expectedResult;
        this.factory = new BestFirstSelectorFactory<Integer, Integer>(interest){
            private final CostEvaluator<Integer> evaluator;
            {
                this.evaluator = CommonEvaluators.intCostEvaluator((String)"length");
            }

            protected Integer getStartData() {
                return 0;
            }

            protected Integer addPriority(TraversalBranch source, Integer currentAggregatedValue, Integer value) {
                return value + currentAggregatedValue;
            }

            protected Integer calculateValue(TraversalBranch next) {
                return next.length() == 0 ? Integer.valueOf(0) : (Integer)this.evaluator.getCost(next.lastRelationship(), Direction.BOTH);
            }
        };
    }
}

