/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.path;

import common.Neo4jAlgoTestCase;
import java.util.HashMap;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.CommonEvaluators;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphalgo.impl.path.Dijkstra;
import org.neo4j.graphalgo.impl.util.PathInterestFactory;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.InitialBranchState;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.util.NoneStrictMath;

public class DijkstraIncreasingWeightTest
extends Neo4jAlgoTestCase {
    @Test
    public void canFetchLongerPaths() {
        Node s = graph.makeNode("s");
        Node a = graph.makeNode("a");
        Node b = graph.makeNode("b");
        Node c = graph.makeNode("c");
        Node d = graph.makeNode("d");
        Node t = graph.makeNode("t");
        graph.makeEdge("s", "a", "length", 1);
        graph.makeEdge("a", "c", "length", 1);
        graph.makeEdge("s", "b", "length", 1);
        graph.makeEdge("b", "a", "length", 1);
        graph.makeEdge("c", "d", "length", 10);
        graph.makeEdge("d", "t", "length", 10);
        PathExpander expander = PathExpanders.allTypesAndDirections();
        Dijkstra algo = new Dijkstra(expander, CommonEvaluators.doubleCostEvaluator((String)"length"), PathInterestFactory.all((double)NoneStrictMath.EPSILON));
        Iterator paths = algo.findAllPaths(s, t).iterator();
        Assert.assertTrue((String)"Expected at least one path.", (boolean)paths.hasNext());
        this.assertPath((Path)paths.next(), s, a, c, d, t);
        Assert.assertTrue((String)"Expected two paths", (boolean)paths.hasNext());
        this.assertPath((Path)paths.next(), s, b, a, c, d, t);
    }

    @Test
    public void shouldReturnPathsInIncreasingOrderOfCost() {
        int i;
        Node s = graph.makeNode("s");
        Node t = graph.makeNode("t");
        graph.makeEdgeChain("s,e,f", "length", 1.0);
        graph.makeEdge("f", "t", "length", 2);
        graph.makeEdge("s", "a", "length", 2);
        graph.makeEdge("a", "t", "length", 0);
        graph.makeEdge("s", "c", "length", 1);
        graph.makeEdge("c", "d", "length", 1);
        graph.makeEdge("s", "b", "length", 1);
        graph.makeEdge("b", "d", "length", 1);
        graph.makeEdge("d", "a", "length", 0);
        graph.makeEdge("d", "t", "length", 1);
        PathExpander expander = PathExpanders.allTypesAndDirections();
        Dijkstra algo = new Dijkstra(expander, CommonEvaluators.doubleCostEvaluator((String)"length"), PathInterestFactory.all((double)NoneStrictMath.EPSILON));
        Iterator paths = algo.findAllPaths(s, t).iterator();
        for (i = 1; i <= 3; ++i) {
            Assert.assertTrue((String)("Expected at least " + i + " path(s)"), (boolean)paths.hasNext());
            Assert.assertTrue((String)"Expected 3 paths of cost 2", (boolean)NoneStrictMath.equals((double)((WeightedPath)paths.next()).weight(), (double)2.0));
        }
        for (i = 1; i <= 3; ++i) {
            Assert.assertTrue((String)("Expected at least " + i + " path(s)"), (boolean)paths.hasNext());
            Assert.assertTrue((String)"Expected 3 paths of cost 3", (boolean)NoneStrictMath.equals((double)((WeightedPath)paths.next()).weight(), (double)3.0));
        }
        Assert.assertTrue((String)"Expected at least 7 paths", (boolean)paths.hasNext());
        Assert.assertTrue((String)"Expected 1 path of cost 4", (boolean)NoneStrictMath.equals((double)((WeightedPath)paths.next()).weight(), (double)4.0));
        Assert.assertFalse((String)"Expected exactly 7 paths", (boolean)paths.hasNext());
    }

    @Test(timeout=5000L)
    public void testForLoops() {
        try (Transaction tx = graphDb.beginTx();){
            Node s = graph.makeNode("s");
            Node t = graph.makeNode("t");
            graph.makeEdge("s", "a1", "length", 1);
            graph.makeEdge("a1", "b", "length", 0);
            graph.makeEdge("b", "a1", "length", 0);
            graph.makeEdge("a1", "a2", "length", 1);
            graph.makeEdge("a2", "a2", "length", 0);
            graph.makeEdge("a2", "a3", "length", 1);
            graph.makeEdge("a3", "c1", "length", 0);
            graph.makeEdge("a3", "c2", "length", 0);
            graph.makeEdge("c1", "a4", "length", 0);
            graph.makeEdge("c1", "a4", "length", 0);
            graph.makeEdge("a4", "t", "length", 1);
            PathExpander expander = PathExpanders.allTypesAndDirections();
            Dijkstra algo = new Dijkstra(expander, CommonEvaluators.doubleCostEvaluator((String)"length"), PathInterestFactory.all((double)NoneStrictMath.EPSILON));
            Iterator paths = algo.findAllPaths(s, t).iterator();
            Assert.assertTrue((String)"Expected at least one path", (boolean)paths.hasNext());
            Assert.assertTrue((String)"Expected first path of length 6", (((WeightedPath)paths.next()).length() == 6 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Expected at least two paths", (boolean)paths.hasNext());
            Assert.assertTrue((String)"Expected second path of length 6", (((WeightedPath)paths.next()).length() == 6 ? 1 : 0) != 0);
            Assert.assertFalse((String)"Expected exactly two paths", (boolean)paths.hasNext());
            tx.success();
        }
    }

    @Test
    public void testKShortestPaths() {
        Node s = graph.makeNode("s");
        Node t = graph.makeNode("t");
        graph.makeEdge("s", "a", "length", 2);
        graph.makeEdge("s", "b", "length", 1);
        graph.makeEdge("s", "c", "length", 1);
        graph.makeEdge("s", "e", "length", 3);
        graph.makeEdge("a", "t", "length", 0);
        graph.makeEdge("b", "d", "length", 1);
        graph.makeEdge("c", "d", "length", 1);
        graph.makeEdge("d", "a", "length", 0);
        graph.makeEdge("d", "t", "length", 1);
        graph.makeEdge("e", "f", "length", 3);
        graph.makeEdge("f", "t", "length", 3);
        PathExpander expander = PathExpanders.allTypesAndDirections();
        Dijkstra algo = new Dijkstra(expander, CommonEvaluators.doubleCostEvaluator((String)"length"), PathInterestFactory.numberOfShortest((double)NoneStrictMath.EPSILON, (int)6));
        Iterator paths = algo.findAllPaths(s, t).iterator();
        int count = 0;
        while (paths.hasNext()) {
            WeightedPath path = (WeightedPath)paths.next();
            double expectedWeight = ++count <= 3 ? 2.0 : 3.0;
            Assert.assertTrue((String)("Expected path number " + count + " to have weight of " + expectedWeight), (boolean)NoneStrictMath.equals((double)path.weight(), (double)expectedWeight));
        }
        Assert.assertTrue((String)"Expected exactly 6 returned paths", (count == 6 ? 1 : 0) != 0);
    }

    @Test
    public void withState() throws Exception {
        graph.makeEdgeChain("a,b,c,d");
        this.setWeight("a", "b", 1.0);
        this.setWeight("b", "c", 2.0);
        this.setWeight("c", "d", 5.0);
        InitialBranchState.State state = new InitialBranchState.State((Object)0, (Object)0);
        final HashMap encounteredState = new HashMap();
        PathExpander<Integer> expander = new PathExpander<Integer>(){

            public Iterable<Relationship> expand(Path path, BranchState<Integer> state) {
                if (path.length() > 0) {
                    int newState = (Integer)state.getState() + ((Number)path.lastRelationship().getProperty("weight")).intValue();
                    state.setState((Object)newState);
                    encounteredState.put(path.endNode(), newState);
                }
                return path.endNode().getRelationships();
            }

            public PathExpander<Integer> reverse() {
                return this;
            }
        };
        Dijkstra finder = new Dijkstra((PathExpander)expander, (InitialBranchState)state, CommonEvaluators.doubleCostEvaluator((String)"weight"));
        this.assertPaths((Iterable<? extends Path>)finder.findAllPaths(graph.getNode("a"), graph.getNode("d")), "a,b,c,d");
        Assert.assertEquals((long)1L, (long)((Integer)encounteredState.get(graph.getNode("b"))).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)encounteredState.get(graph.getNode("c"))).intValue());
        Assert.assertEquals((long)8L, (long)((Integer)encounteredState.get(graph.getNode("d"))).intValue());
    }

    private void setWeight(String start, String end, double weight) {
        Node startNode = graph.getNode(start);
        Node endNode = graph.getNode(end);
        ResourceIterable relationships = Iterables.asResourceIterable((Iterable)startNode.getRelationships());
        try (ResourceIterator resourceIterator = relationships.iterator();){
            while (resourceIterator.hasNext()) {
                Relationship rel = (Relationship)resourceIterator.next();
                if (!rel.getOtherNode(startNode).equals(endNode)) continue;
                rel.setProperty("weight", (Object)weight);
                return;
            }
        }
        throw new RuntimeException("No relationship between nodes " + start + " and " + end);
    }
}

