/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.path;

import common.Neo4jAlgoTestCase;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphalgo.CommonEvaluators;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.EstimateEvaluator;
import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphalgo.impl.path.TraversalAStar;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.InitialBranchState;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;

@RunWith(value=Parameterized.class)
public class TestAStar
extends Neo4jAlgoTestCase {
    static EstimateEvaluator<Double> ESTIMATE_EVALUATOR = (node, goal) -> {
        double dx = (Double)node.getProperty("x") - (Double)goal.getProperty("x");
        double dy = (Double)node.getProperty("y") - (Double)goal.getProperty("y");
        return Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
    };
    private final PathFinder<WeightedPath> finder;

    @Test
    public void pathToSelfReturnsZero() {
        Node start = graph.makeNode("start", "x", 0.0, "y", 0.0);
        WeightedPath path = (WeightedPath)this.finder.findSinglePath(start, start);
        Assert.assertNotNull((Object)path);
        Assert.assertEquals((Object)start, (Object)path.startNode());
        Assert.assertEquals((Object)start, (Object)path.endNode());
        Assert.assertEquals((long)0L, (long)path.length());
    }

    @Test
    public void allPathsToSelfReturnsZero() {
        Node start = graph.makeNode("start", "x", 0.0, "y", 0.0);
        ResourceIterable paths = Iterables.asResourceIterable((Iterable)this.finder.findAllPaths(start, start));
        for (WeightedPath path : paths) {
            Assert.assertNotNull((Object)path);
            Assert.assertEquals((Object)start, (Object)path.startNode());
            Assert.assertEquals((Object)start, (Object)path.endNode());
            Assert.assertEquals((long)0L, (long)path.length());
        }
    }

    @Test
    public void wikipediaExample() throws Exception {
        Node start = graph.makeNode("start", "x", 0.0, "y", 0.0);
        graph.makeNode("a", "x", 0.3, "y", 1.0);
        graph.makeNode("b", "x", 2.0, "y", 2.0);
        graph.makeNode("c", "x", 0.0, "y", 3.0);
        graph.makeNode("d", "x", 2.0, "y", 0.0);
        graph.makeNode("e", "x", 3.0, "y", 1.5);
        Node end = graph.makeNode("end", "x", 3.3, "y", 2.8);
        graph.makeEdge("start", "a", "length", 1.5);
        graph.makeEdge("a", "b", "length", Float.valueOf(2.0f));
        graph.makeEdge("b", "c", "length", 3);
        graph.makeEdge("c", "end", "length", 4L);
        graph.makeEdge("start", "d", "length", (short)2);
        graph.makeEdge("d", "e", "length", (byte)3);
        graph.makeEdge("e", "end", "length", 2);
        WeightedPath path = (WeightedPath)this.finder.findSinglePath(start, end);
        this.assertPathDef((Path)path, "start", "d", "e", "end");
    }

    @Test
    public void testSimplest() {
        Node nodeA = graph.makeNode("A", "x", 0.0, "y", 0.0);
        Node nodeB = graph.makeNode("B", "x", 2.0, "y", 1.0);
        Node nodeC = graph.makeNode("C", "x", 7.0, "y", 0.0);
        Relationship relAB = graph.makeEdge("A", "B", "length", 2.0);
        Relationship relAB2 = graph.makeEdge("A", "B", "length", 2);
        Relationship relBC = graph.makeEdge("B", "C", "length", Float.valueOf(3.0f));
        Relationship relAC = graph.makeEdge("A", "C", "length", (short)10);
        int counter = 0;
        Iterable allPaths = this.finder.findAllPaths(nodeA, nodeC);
        for (WeightedPath path : allPaths) {
            Assert.assertEquals((Object)5.0, (Object)path.weight());
            this.assertPath((Path)path, nodeA, nodeB, nodeC);
            ++counter;
        }
        Assert.assertEquals((long)1L, (long)counter);
    }

    @Test
    public void canUseBranchState() throws Exception {
        Node nodeA = graph.makeNode("A", "x", 0.0, "y", 0.0);
        Node nodeB = graph.makeNode("B", "x", 2.0, "y", 1.0);
        Node nodeC = graph.makeNode("C", "x", 7.0, "y", 0.0);
        graph.makeEdge("A", "B", "length", 2.0);
        graph.makeEdge("A", "B", "length", 2.0);
        graph.makeEdge("B", "C", "length", 3.0);
        graph.makeEdge("A", "C", "length", 10.0);
        final HashMap seenBranchStates = new HashMap();
        PathExpander<Double> expander = new PathExpander<Double>(){

            public Iterable<Relationship> expand(Path path, BranchState<Double> state) {
                double newState = (Double)state.getState();
                if (path.length() > 0) {
                    state.setState((Object)(newState += ((Double)path.lastRelationship().getProperty("length")).doubleValue()));
                }
                seenBranchStates.put(path.endNode(), newState);
                return path.endNode().getRelationships(Direction.OUTGOING);
            }

            public PathExpander<Double> reverse() {
                throw new UnsupportedOperationException();
            }
        };
        double initialStateValue = 0.0;
        TraversalAStar traversalFinder = new TraversalAStar((PathExpander)expander, (InitialBranchState)new InitialBranchState.State((Object)initialStateValue, (Object)initialStateValue), CommonEvaluators.doubleCostEvaluator((String)"length"), ESTIMATE_EVALUATOR);
        WeightedPath path = (WeightedPath)traversalFinder.findSinglePath(nodeA, nodeC);
        Assert.assertEquals((Object)5.0, (Object)path.weight());
        this.assertPathDef((Path)path, "A", "B", "C");
        Assert.assertEquals((Object)MapUtil.genericMap((Object[])new Object[]{nodeA, 0.0, nodeB, 2.0}), seenBranchStates);
    }

    @Test
    public void betterTentativePath() throws Exception {
        EstimateEvaluator estimator = (node, goal) -> (Double)node.getProperty("estimate");
        PathFinder finder = GraphAlgoFactory.aStar((PathExpander)PathExpanders.allTypesAndDirections(), (CostEvaluator)CommonEvaluators.doubleCostEvaluator((String)"weight", (double)0.0), (EstimateEvaluator)estimator);
        Node node1 = graph.makeNode("1", "estimate", 0.003);
        Node node2 = graph.makeNode("2", "estimate", 0.002);
        Node node3 = graph.makeNode("3", "estimate", 0.001);
        Node node4 = graph.makeNode("4", "estimate", 0.0);
        graph.makeEdge("1", "3", "weight", 0.253);
        graph.makeEdge("1", "2", "weight", 0.018);
        graph.makeEdge("2", "4", "weight", 0.21);
        graph.makeEdge("2", "3", "weight", 0.18);
        graph.makeEdge("2", "3", "weight", 0.024);
        graph.makeEdge("3", "4", "weight", 0.135);
        graph.makeEdge("3", "4", "weight", 0.013);
        WeightedPath best1_4 = (WeightedPath)finder.findSinglePath(node1, node4);
        this.assertPath((Path)best1_4, node1, node2, node3, node4);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({GraphAlgoFactory.aStar((PathExpander)PathExpanders.allTypesAndDirections(), (CostEvaluator)CommonEvaluators.doubleCostEvaluator((String)"length"), ESTIMATE_EVALUATOR)}, {new TraversalAStar(PathExpanders.allTypesAndDirections(), CommonEvaluators.doubleCostEvaluator((String)"length"), ESTIMATE_EVALUATOR)});
    }

    public TestAStar(PathFinder<WeightedPath> finder) {
        this.finder = finder;
    }
}

