/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpath;

import common.Neo4jAlgoTestCase;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPath;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public abstract class SingleSourceShortestPathTest
extends Neo4jAlgoTestCase {
    protected abstract SingleSourceShortestPath<Integer> getSingleSourceAlgorithm(Node var1);

    protected abstract SingleSourceShortestPath<Integer> getSingleSourceAlgorithm(Node var1, Direction var2, RelationshipType ... var3);

    @Test
    public void testRun() {
        graph.makeEdgeChain("a,b1,c1,d1,e1,f1,g1");
        graph.makeEdgeChain("a,b2,c2,d2,e2,f2,g2");
        graph.makeEdgeChain("a,b3,c3,d3,e3,f3,g3");
        graph.makeEdgeChain("b1,b2,b3,b1");
        graph.makeEdgeChain("d1,d2,d3,d1");
        graph.makeEdgeChain("f1,f2,f3,f1");
        SingleSourceShortestPath<Integer> singleSource = this.getSingleSourceAlgorithm(graph.getNode("a"));
        Assert.assertTrue(((Integer)singleSource.getCost(graph.getNode("a")) == 0 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)singleSource.getCost(graph.getNode("b2")) == 1 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)singleSource.getCost(graph.getNode("c3")) == 2 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)singleSource.getCost(graph.getNode("d1")) == 3 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)singleSource.getCost(graph.getNode("e2")) == 4 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)singleSource.getCost(graph.getNode("f3")) == 5 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)singleSource.getCost(graph.getNode("g1")) == 6 ? 1 : 0) != 0);
        List path = singleSource.getPathAsNodes(graph.getNode("g2"));
        Assert.assertTrue((path.size() == 7 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Node)path.get(0)).equals(graph.getNode("a")));
        Assert.assertTrue((boolean)((Node)path.get(1)).equals(graph.getNode("b2")));
        Assert.assertTrue((boolean)((Node)path.get(2)).equals(graph.getNode("c2")));
        Assert.assertTrue((boolean)((Node)path.get(3)).equals(graph.getNode("d2")));
        Assert.assertTrue((boolean)((Node)path.get(4)).equals(graph.getNode("e2")));
        Assert.assertTrue((boolean)((Node)path.get(5)).equals(graph.getNode("f2")));
        Assert.assertTrue((boolean)((Node)path.get(6)).equals(graph.getNode("g2")));
        List rpath = singleSource.getPathAsRelationships(graph.getNode("g2"));
        Assert.assertTrue((rpath.size() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Relationship)rpath.get(0)).equals(graph.getRelationship("a", "b2")));
        Assert.assertTrue((boolean)((Relationship)rpath.get(1)).equals(graph.getRelationship("b2", "c2")));
        Assert.assertTrue((boolean)((Relationship)rpath.get(2)).equals(graph.getRelationship("c2", "d2")));
        Assert.assertTrue((boolean)((Relationship)rpath.get(3)).equals(graph.getRelationship("d2", "e2")));
        Assert.assertTrue((boolean)((Relationship)rpath.get(4)).equals(graph.getRelationship("e2", "f2")));
        Assert.assertTrue((boolean)((Relationship)rpath.get(5)).equals(graph.getRelationship("f2", "g2")));
        List cpath = singleSource.getPath(graph.getNode("g2"));
        Assert.assertTrue((cpath.size() == 13 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((PropertyContainer)cpath.get(0)).equals(graph.getNode("a")));
        Assert.assertTrue((boolean)((PropertyContainer)cpath.get(2)).equals(graph.getNode("b2")));
        Assert.assertTrue((boolean)((PropertyContainer)cpath.get(4)).equals(graph.getNode("c2")));
        Assert.assertTrue((boolean)((PropertyContainer)cpath.get(6)).equals(graph.getNode("d2")));
        Assert.assertTrue((boolean)((PropertyContainer)cpath.get(8)).equals(graph.getNode("e2")));
        Assert.assertTrue((boolean)((PropertyContainer)cpath.get(10)).equals(graph.getNode("f2")));
        Assert.assertTrue((boolean)((PropertyContainer)cpath.get(12)).equals(graph.getNode("g2")));
        Assert.assertTrue((boolean)((PropertyContainer)cpath.get(1)).equals(graph.getRelationship("a", "b2")));
        Assert.assertTrue((boolean)((PropertyContainer)cpath.get(3)).equals(graph.getRelationship("b2", "c2")));
        Assert.assertTrue((boolean)((PropertyContainer)cpath.get(5)).equals(graph.getRelationship("c2", "d2")));
        Assert.assertTrue((boolean)((PropertyContainer)cpath.get(7)).equals(graph.getRelationship("d2", "e2")));
        Assert.assertTrue((boolean)((PropertyContainer)cpath.get(9)).equals(graph.getRelationship("e2", "f2")));
        Assert.assertTrue((boolean)((PropertyContainer)cpath.get(11)).equals(graph.getRelationship("f2", "g2")));
        graph.clear();
    }

    @Test
    public void testMultipleRelTypes() {
        graph.setCurrentRelType(Neo4jAlgoTestCase.MyRelTypes.R1);
        graph.makeEdgeChain("a,b,c,d,e");
        graph.setCurrentRelType(Neo4jAlgoTestCase.MyRelTypes.R2);
        graph.makeEdges("a,c");
        graph.setCurrentRelType(Neo4jAlgoTestCase.MyRelTypes.R3);
        graph.makeEdges("c,e");
        SingleSourceShortestPath<Integer> singleSource = this.getSingleSourceAlgorithm(graph.getNode("a"), Direction.BOTH, Neo4jAlgoTestCase.MyRelTypes.R1);
        Assert.assertTrue(((Integer)singleSource.getCost(graph.getNode("e")) == 4 ? 1 : 0) != 0);
        singleSource = this.getSingleSourceAlgorithm(graph.getNode("a"), Direction.BOTH, Neo4jAlgoTestCase.MyRelTypes.R1, Neo4jAlgoTestCase.MyRelTypes.R2);
        Assert.assertTrue(((Integer)singleSource.getCost(graph.getNode("e")) == 3 ? 1 : 0) != 0);
        singleSource = this.getSingleSourceAlgorithm(graph.getNode("a"), Direction.BOTH, Neo4jAlgoTestCase.MyRelTypes.R1, Neo4jAlgoTestCase.MyRelTypes.R3);
        Assert.assertTrue(((Integer)singleSource.getCost(graph.getNode("e")) == 3 ? 1 : 0) != 0);
        singleSource = this.getSingleSourceAlgorithm(graph.getNode("a"), Direction.BOTH, Neo4jAlgoTestCase.MyRelTypes.R1, Neo4jAlgoTestCase.MyRelTypes.R2, Neo4jAlgoTestCase.MyRelTypes.R3);
        Assert.assertTrue(((Integer)singleSource.getCost(graph.getNode("e")) == 2 ? 1 : 0) != 0);
    }
}

