/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.internal.helpers.MathUtil;

public interface ExecutionPlanDescription {
    public String getName();

    public List<ExecutionPlanDescription> getChildren();

    public Map<String, Object> getArguments();

    public Set<String> getIdentifiers();

    public boolean hasProfilerStatistics();

    public ProfilerStatistics getProfilerStatistics();

    public static interface ProfilerStatistics {
        public boolean hasRows();

        public long getRows();

        public boolean hasDbHits();

        public long getDbHits();

        public boolean hasPageCacheStats();

        public long getPageCacheHits();

        public long getPageCacheMisses();

        default public double getPageCacheHitRatio() {
            return MathUtil.portion((double[])new double[]{this.getPageCacheHits(), this.getPageCacheMisses()});
        }

        public boolean hasTime();

        public long getTime();
    }
}

