/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.util.function.Function;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.tooling.EntityDataGenerator;
import org.neo4j.unsafe.impl.batchimport.IdRangeInput;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;

public class DataGeneratorInput
implements Input {
    private final long nodes;
    private final long relationships;
    private final Function<IdRangeInput.Range, InputNode[]> nodeGenerator;
    private final Function<IdRangeInput.Range, InputRelationship[]> relGenerator;
    private final IdType idType;
    private final Collector badCollector;

    public DataGeneratorInput(long nodes, long relationships, Function<IdRangeInput.Range, InputNode[]> nodeGenerator, Function<IdRangeInput.Range, InputRelationship[]> relGenerator, IdType idType, Collector badCollector) {
        this.nodes = nodes;
        this.relationships = relationships;
        this.nodeGenerator = nodeGenerator;
        this.relGenerator = relGenerator;
        this.idType = idType;
        this.badCollector = badCollector;
    }

    public InputIterable<InputNode> nodes() {
        return new InputIterable<InputNode>(){

            public InputIterator<InputNode> iterator() {
                return new EntityDataGenerator(DataGeneratorInput.this.nodeGenerator, DataGeneratorInput.this.nodes);
            }

            public boolean supportsMultiplePasses() {
                return true;
            }
        };
    }

    public InputIterable<InputRelationship> relationships() {
        return new InputIterable<InputRelationship>(){

            public InputIterator<InputRelationship> iterator() {
                return new EntityDataGenerator(DataGeneratorInput.this.relGenerator, DataGeneratorInput.this.relationships);
            }

            public boolean supportsMultiplePasses() {
                return true;
            }
        };
    }

    public IdMapper idMapper() {
        return this.idType.idMapper();
    }

    public IdGenerator idGenerator() {
        return this.idType.idGenerator();
    }

    public Collector badCollector() {
        return this.badCollector;
    }

    public static Header sillyNodeHeader(IdType idType, Extractors extractors) {
        return new Header(new Header.Entry[]{new Header.Entry(null, Type.ID, null, idType.extractor(extractors)), new Header.Entry("name", Type.PROPERTY, null, extractors.string()), new Header.Entry("age", Type.PROPERTY, null, (Extractor)extractors.int_()), new Header.Entry("something", Type.PROPERTY, null, extractors.string()), new Header.Entry(null, Type.LABEL, null, extractors.stringArray())});
    }

    public static Header bareboneNodeHeader(IdType idType, Extractors extractors) {
        return new Header(new Header.Entry[]{new Header.Entry(null, Type.ID, null, idType.extractor(extractors)), new Header.Entry(null, Type.LABEL, null, extractors.stringArray())});
    }

    public static Header bareboneRelationshipHeader(IdType idType, Extractors extractors) {
        return new Header(new Header.Entry[]{new Header.Entry(null, Type.START_ID, null, idType.extractor(extractors)), new Header.Entry(null, Type.END_ID, null, idType.extractor(extractors)), new Header.Entry(null, Type.TYPE, null, extractors.string())});
    }
}

