/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.tooling.ImportToolTest;
import org.neo4j.unsafe.impl.batchimport.input.InputException;

@RunWith(value=Parameterized.class)
public class ImportToolNumericalFailureTests {
    @Parameterized.Parameter
    public String type;
    @Parameterized.Parameter(value=1)
    public String val;
    @Parameterized.Parameter(value=2)
    public String expectedError;
    @Rule
    public final EmbeddedDatabaseRule dbRule = new EmbeddedDatabaseRule(this.getClass()).startLazily();
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppress((SuppressOutput.Suppressible[])SuppressOutput.System.values());
    private int dataIndex;

    @Parameterized.Parameters(name="{index}: {0}, \"{1}\", \"{2}\"")
    public static List<Object[]> types() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String type : Arrays.asList("int", "long", "short", "byte", "float", "double")) {
            for (String val : Arrays.asList(" 1 7 ", " -1 7 ", " - 1 ", "   ", "   -  ", "-", "1. 0", "1 .", ".", "1E 10", " . 1")) {
                if (val.contains(".") && !type.equals("float") && !type.equals("double")) continue;
                String error = type.equals("float") || type.equals("double") ? "Not a number: \"" + val + "\"" : "Not an integer: \"" + val + "\"";
                String[] args = new String[]{type, val, error};
                params.add(args);
            }
        }
        return params;
    }

    @Test
    public void test() throws Exception {
        File data = this.file(this.fileName("whitespace.csv"));
        try (PrintStream writer = new PrintStream(data);){
            writer.println(":LABEL,adult:" + this.type);
            writer.println("PERSON," + this.val);
        }
        try {
            ImportToolTest.importTool("--into", this.dbRule.getStoreDirAbsolutePath(), "--quote", "'", "--nodes", data.getAbsolutePath());
            Assert.fail((String)"Expected import to fail");
        }
        catch (Exception e) {
            ImportToolTest.assertExceptionContains(e, this.expectedError, InputException.class);
        }
    }

    private String fileName(String name) {
        return this.dataIndex++ + "-" + name;
    }

    private File file(String localname) {
        return new File(this.dbRule.getStoreDir(), localname);
    }
}

