/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.function.Function;
import org.neo4j.tooling.StringDeserialization;
import org.neo4j.unsafe.impl.batchimport.BatchImporter;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.Deserialization;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;

public class CsvOutput
implements BatchImporter {
    private final File targetDirectory;
    private final Header nodeHeader;
    private final Header relationshipHeader;
    private final Deserialization<String> deserialization;

    public CsvOutput(File targetDirectory, Header nodeHeader, Header relationshipHeader, Configuration config) {
        this.targetDirectory = targetDirectory;
        assert (targetDirectory.isDirectory());
        this.nodeHeader = nodeHeader;
        this.relationshipHeader = relationshipHeader;
        this.deserialization = new StringDeserialization(config);
        targetDirectory.mkdirs();
    }

    public void doImport(Input input) throws IOException {
        this.consume("nodes.csv", input.nodes(), this.nodeHeader, node -> {
            this.deserialization.clear();
            block5: for (Header.Entry entry : this.nodeHeader.entries()) {
                switch (entry.type()) {
                    case ID: {
                        this.deserialization.handle(entry, node.id());
                        continue block5;
                    }
                    case PROPERTY: {
                        this.deserialization.handle(entry, this.property((InputEntity)node, entry.name()));
                        continue block5;
                    }
                    case LABEL: {
                        this.deserialization.handle(entry, (Object)node.labels());
                        continue block5;
                    }
                }
            }
            return (String)this.deserialization.materialize();
        });
        this.consume("relationships.csv", input.relationships(), this.relationshipHeader, relationship -> {
            this.deserialization.clear();
            block6: for (Header.Entry entry : this.relationshipHeader.entries()) {
                switch (entry.type()) {
                    case PROPERTY: {
                        this.deserialization.handle(entry, this.property((InputEntity)relationship, entry.name()));
                        continue block6;
                    }
                    case TYPE: {
                        this.deserialization.handle(entry, (Object)relationship.type());
                        continue block6;
                    }
                    case START_ID: {
                        this.deserialization.handle(entry, relationship.startNode());
                        continue block6;
                    }
                    case END_ID: {
                        this.deserialization.handle(entry, relationship.endNode());
                        continue block6;
                    }
                }
            }
            return (String)this.deserialization.materialize();
        });
    }

    private Object property(InputEntity entity, String key) {
        Object[] properties = entity.properties();
        for (int i = 0; i < properties.length; i += 2) {
            if (!properties[i].equals(key)) continue;
            return properties[i + 1];
        }
        return null;
    }

    private <ENTITY extends InputEntity> void consume(String name, InputIterable<ENTITY> entities, Header header, Function<ENTITY, String> deserializer) throws IOException {
        try (PrintStream out = this.file(name);){
            this.serialize(out, header);
            try (InputIterator iterator = entities.iterator();){
                while (iterator.hasNext()) {
                    out.println(deserializer.apply(iterator.next()));
                }
            }
        }
    }

    private void serialize(PrintStream out, Header header) {
        this.deserialization.clear();
        for (Header.Entry entry : header.entries()) {
            this.deserialization.handle(entry, (Object)entry.toString());
        }
        out.println((String)this.deserialization.materialize());
    }

    private PrintStream file(String name) throws IOException {
        return new PrintStream(new File(this.targetDirectory, name));
    }
}

