/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.tooling.CharacterConverter;

class CharacterConverterTest {
    private final CharacterConverter converter = new CharacterConverter();

    CharacterConverterTest() {
    }

    @Test
    void shouldConvertCharacter() {
        String candidates = "abcdefghijklmnopqrstuvwxyz\u00e5\u00e4\u00f6\"'^`\\";
        for (int i = 0; i < candidates.length(); ++i) {
            char expected = candidates.charAt(i);
            this.assertCorrectConversion(expected, String.valueOf(expected));
        }
    }

    @Test
    void shouldConvertRawAscii() {
        for (char expected = '\u0000'; expected < '\uffff'; expected = (char)(expected + '\u0001')) {
            this.assertCorrectConversion(expected, "\\" + expected);
        }
    }

    @Test
    void shouldConvertEscaped_t_AsTab() {
        char expected = '\t';
        this.assertCorrectConversion(expected, "\\t");
    }

    @Test
    void shouldConvert_t_AsTab() {
        char expected = '\t';
        this.assertCorrectConversion(expected, "\t");
    }

    @Test
    void shouldConvertSpelledOut_TAB_AsTab() {
        char expected = '\t';
        this.assertCorrectConversion(expected, "TAB");
    }

    @Test
    void shouldNotAcceptRandomEscapedStrings() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.converter.apply("\\bogus"));
    }

    @Test
    void shouldNotAcceptStrings() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.converter.apply("bogus"));
    }

    private void assertCorrectConversion(char expected, String material) {
        char converted = this.converter.apply(material).charValue();
        Assertions.assertEquals((char)expected, (char)converted);
    }
}

