/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.neo4j.io.ByteUnit;
import org.neo4j.unsafe.impl.batchimport.BatchImporter;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputChunk;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;
import org.neo4j.unsafe.impl.batchimport.input.RandomEntityDataGenerator;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.Deserialization;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.StringDeserialization;

public class CsvOutput
implements BatchImporter {
    private final File targetDirectory;
    private final Header nodeHeader;
    private final Header relationshipHeader;
    private Configuration config;
    private final Deserialization<String> deserialization;

    public CsvOutput(File targetDirectory, Header nodeHeader, Header relationshipHeader, Configuration config) {
        this.targetDirectory = targetDirectory;
        assert (targetDirectory.isDirectory());
        this.nodeHeader = nodeHeader;
        this.relationshipHeader = relationshipHeader;
        this.config = config;
        this.deserialization = new StringDeserialization(config);
        targetDirectory.mkdirs();
    }

    public void doImport(Input input) throws IOException {
        this.consume("nodes", input.nodes().iterator(), this.nodeHeader, RandomEntityDataGenerator::convert);
        this.consume("relationships", input.relationships().iterator(), this.relationshipHeader, RandomEntityDataGenerator::convert);
    }

    private void consume(String name, InputIterator entities, Header header, Deserializer deserializer) throws IOException {
        try (PrintStream out = this.file(name + "header.csv");){
            this.serialize(out, header);
        }
        try {
            int threads = Runtime.getRuntime().availableProcessors();
            ExecutorService executor = Executors.newFixedThreadPool(threads);
            int i = 0;
            while (i < threads) {
                int id = i++;
                executor.submit(() -> {
                    StringDeserialization deserialization = new StringDeserialization(this.config);
                    try (PrintStream out = this.file(name + "-" + id + ".csv");
                         InputChunk chunk = entities.newChunk();){
                        InputEntity entity = new InputEntity();
                        while (entities.next(chunk)) {
                            while (chunk.next((InputEntityVisitor)entity)) {
                                out.println(deserializer.apply(entity, (Deserialization<String>)deserialization, header));
                            }
                        }
                    }
                    return null;
                });
            }
            executor.shutdown();
            executor.awaitTermination(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    private void serialize(PrintStream out, Header header) {
        this.deserialization.clear();
        for (Header.Entry entry : header.entries()) {
            this.deserialization.handle(entry, (Object)entry.toString());
        }
        out.println((String)this.deserialization.materialize());
    }

    private PrintStream file(String name) throws IOException {
        return new PrintStream(new BufferedOutputStream(new FileOutputStream(new File(this.targetDirectory, name)), (int)ByteUnit.mebiBytes((long)1L)));
    }

    private static interface Deserializer {
        public String apply(InputEntity var1, Deserialization<String> var2, Header var3);
    }
}

