/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.helpers.Format;
import org.neo4j.io.ByteUnit;
import org.neo4j.tooling.PrintingImportLogicMonitor;
import org.neo4j.unsafe.impl.batchimport.ImportLogic;

class PrintingImportLogicMonitorTest {
    private final ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
    private final PrintStream out = new PrintStream(this.outBuffer);
    private final ByteArrayOutputStream errBuffer = new ByteArrayOutputStream();
    private final PrintStream err = new PrintStream(this.errBuffer);
    private final ImportLogic.Monitor monitor = new PrintingImportLogicMonitor(this.out, this.err);

    PrintingImportLogicMonitorTest() {
    }

    @Test
    void mayExceedNodeIdCapacity() {
        long capacity = 10000000L;
        long estimatedCount = 12000000L;
        this.monitor.mayExceedNodeIdCapacity(capacity, estimatedCount);
        String text = this.errBuffer.toString();
        Assertions.assertTrue((boolean)text.contains("WARNING"));
        Assertions.assertTrue((boolean)text.contains("exceed"));
        Assertions.assertTrue((boolean)text.contains(String.valueOf(capacity)));
        Assertions.assertTrue((boolean)text.contains(String.valueOf(estimatedCount)));
    }

    @Test
    void mayExceedRelationshipIdCapacity() {
        long capacity = 10000000L;
        long estimatedCount = 12000000L;
        this.monitor.mayExceedRelationshipIdCapacity(capacity, estimatedCount);
        String text = this.errBuffer.toString();
        Assertions.assertTrue((boolean)text.contains("WARNING"));
        Assertions.assertTrue((boolean)text.contains("exceed"));
        Assertions.assertTrue((boolean)text.contains(String.valueOf(capacity)));
        Assertions.assertTrue((boolean)text.contains(String.valueOf(estimatedCount)));
    }

    @Test
    void insufficientHeapSize() {
        long optimalHeapSize = ByteUnit.gibiBytes((long)2L);
        long heapSize = ByteUnit.gibiBytes((long)1L);
        this.monitor.insufficientHeapSize(optimalHeapSize, heapSize);
        String text = this.errBuffer.toString();
        Assertions.assertTrue((boolean)text.contains("WARNING"));
        Assertions.assertTrue((boolean)text.contains("too small"));
        Assertions.assertTrue((boolean)text.contains(Format.bytes((long)heapSize)));
        Assertions.assertTrue((boolean)text.contains(Format.bytes((long)optimalHeapSize)));
    }

    @Test
    void abundantHeapSize() {
        long optimalHeapSize = ByteUnit.gibiBytes((long)2L);
        long heapSize = ByteUnit.gibiBytes((long)10L);
        this.monitor.abundantHeapSize(optimalHeapSize, heapSize);
        String text = this.errBuffer.toString();
        Assertions.assertTrue((boolean)text.contains("WARNING"));
        Assertions.assertTrue((boolean)text.contains("unnecessarily large"));
        Assertions.assertTrue((boolean)text.contains(Format.bytes((long)heapSize)));
        Assertions.assertTrue((boolean)text.contains(Format.bytes((long)optimalHeapSize)));
    }

    @Test
    void insufficientAvailableMemory() {
        long estimatedCacheSize = ByteUnit.gibiBytes((long)2L);
        long optimalHeapSize = ByteUnit.gibiBytes((long)2L);
        long availableMemory = ByteUnit.gibiBytes((long)1L);
        this.monitor.insufficientAvailableMemory(estimatedCacheSize, optimalHeapSize, availableMemory);
        String text = this.errBuffer.toString();
        Assertions.assertTrue((boolean)text.contains("WARNING"));
        Assertions.assertTrue((boolean)text.contains("may not be sufficient"));
        Assertions.assertTrue((boolean)text.contains(Format.bytes((long)estimatedCacheSize)));
        Assertions.assertTrue((boolean)text.contains(Format.bytes((long)optimalHeapSize)));
        Assertions.assertTrue((boolean)text.contains(Format.bytes((long)availableMemory)));
    }
}

