/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.adversaries.Adversary;

public class ClassGuardedAdversary
implements Adversary {
    private final Adversary delegate;
    private final Set<String> victimClasses;
    private volatile boolean enabled;

    public ClassGuardedAdversary(Adversary delegate, String ... victimClassNames) {
        this.delegate = delegate;
        this.victimClasses = new HashSet<String>();
        Collections.addAll(this.victimClasses, victimClassNames);
        this.enabled = true;
    }

    @Override
    public void injectFailure(Class<? extends Throwable> ... failureTypes) {
        if (this.enabled && this.calledFromVictimClass()) {
            this.delegateFailureInjection(failureTypes);
        }
    }

    @Override
    public boolean injectFailureOrMischief(Class<? extends Throwable> ... failureTypes) {
        if (this.enabled && this.calledFromVictimClass()) {
            return this.delegateFailureOrMischiefInjection(failureTypes);
        }
        return false;
    }

    protected void delegateFailureInjection(Class<? extends Throwable>[] failureTypes) {
        this.delegate.injectFailure(failureTypes);
    }

    protected boolean delegateFailureOrMischiefInjection(Class<? extends Throwable>[] failureTypes) {
        return this.delegate.injectFailureOrMischief(failureTypes);
    }

    private boolean calledFromVictimClass() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!this.victimClasses.contains(element.getClassName())) continue;
            return true;
        }
        return false;
    }

    public void disable() {
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }
}

