/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import org.neo4j.adversaries.Adversary;
import org.neo4j.io.fs.StoreChannel;

public class AdversarialFileChannel
implements StoreChannel {
    private final StoreChannel delegate;
    private final Adversary adversary;

    public AdversarialFileChannel(StoreChannel channel, Adversary adversary) {
        this.delegate = channel;
        this.adversary = adversary;
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.delegate.write(srcs);
    }

    public int write(ByteBuffer src, long position) throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.delegate.write(src, position);
    }

    public void writeAll(ByteBuffer src, long position) throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.delegate.writeAll(src, position);
    }

    public void writeAll(ByteBuffer src) throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.delegate.writeAll(src);
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.delegate.write(srcs, offset, length);
    }

    public StoreChannel truncate(long size) throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.delegate.truncate(size);
    }

    public StoreChannel position(long newPosition) throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.delegate.position(newPosition);
    }

    public int read(ByteBuffer dst, long position) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            int oldLimit = this.mischiefLimit(dst);
            int read = this.delegate.read(dst, position);
            dst.limit(oldLimit);
            return read;
        }
        return this.delegate.read(dst, position);
    }

    private int mischiefLimit(ByteBuffer buf) {
        int oldLimit = buf.limit();
        int newLimit = oldLimit - buf.remaining() / 2;
        buf.limit(newLimit);
        return oldLimit;
    }

    public void force(boolean metaData) throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.delegate.force(metaData);
    }

    public int read(ByteBuffer dst) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            int oldLimit = this.mischiefLimit(dst);
            int read = this.delegate.read(dst);
            dst.limit(oldLimit);
            return read;
        }
        return this.delegate.read(dst);
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            ByteBuffer lastBuf = dsts[dsts.length - 1];
            int oldLimit = this.mischiefLimit(lastBuf);
            long read = this.delegate.read(dsts, offset, length);
            lastBuf.limit(oldLimit);
            return read;
        }
        return this.delegate.read(dsts, offset, length);
    }

    public long position() throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.delegate.position();
    }

    public FileLock tryLock() throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.delegate.tryLock();
    }

    public boolean isOpen() {
        this.adversary.injectFailure(new Class[0]);
        return this.delegate.isOpen();
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        if (this.adversary.injectFailureOrMischief(IOException.class)) {
            ByteBuffer lastBuf = dsts[dsts.length - 1];
            int oldLimit = this.mischiefLimit(lastBuf);
            long read = this.delegate.read(dsts);
            lastBuf.limit(oldLimit);
            return read;
        }
        return this.delegate.read(dsts);
    }

    public int write(ByteBuffer src) throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.delegate.write(src);
    }

    public void close() throws IOException {
        this.adversary.injectFailure(IOException.class);
        this.delegate.close();
    }

    public long size() throws IOException {
        this.adversary.injectFailure(IOException.class);
        return this.delegate.size();
    }
}

