/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.mockfs;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.neo4j.function.Function;
import org.neo4j.graphdb.mockfs.LimitedFileChannel;
import org.neo4j.io.fs.FileLock;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.test.impl.ChannelInputStream;
import org.neo4j.test.impl.ChannelOutputStream;

public class LimitedFilesystemAbstraction
implements FileSystemAbstraction {
    private final FileSystemAbstraction inner;
    private boolean outOfSpace;

    public LimitedFilesystemAbstraction(FileSystemAbstraction wrapped) {
        this.inner = wrapped;
    }

    public StoreChannel open(File fileName, String mode) throws IOException {
        return new LimitedFileChannel(this.inner.open(fileName, mode), this);
    }

    public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
        return new ChannelOutputStream(this.open(fileName, "rw"), append);
    }

    public InputStream openAsInputStream(File fileName) throws IOException {
        return new ChannelInputStream(this.open(fileName, "r"));
    }

    public Reader openAsReader(File fileName, String encoding) throws IOException {
        return new InputStreamReader(this.openAsInputStream(fileName), encoding);
    }

    public Writer openAsWriter(File fileName, String encoding, boolean append) throws IOException {
        return new OutputStreamWriter(this.openAsOutputStream(fileName, append));
    }

    public FileLock tryLock(File fileName, StoreChannel channel) throws IOException {
        return this.inner.tryLock(fileName, channel);
    }

    public StoreChannel create(File fileName) throws IOException {
        this.ensureHasSpace();
        return new LimitedFileChannel(this.inner.create(fileName), this);
    }

    public boolean fileExists(File fileName) {
        return this.inner.fileExists(fileName);
    }

    public long getFileSize(File fileName) {
        return this.inner.getFileSize(fileName);
    }

    public boolean deleteFile(File fileName) {
        return this.inner.deleteFile(fileName);
    }

    public void deleteRecursively(File directory) throws IOException {
        this.inner.deleteRecursively(directory);
    }

    public boolean mkdir(File fileName) {
        return this.inner.mkdir(fileName);
    }

    public void mkdirs(File fileName) throws IOException {
        this.ensureHasSpace();
        this.inner.mkdirs(fileName);
    }

    public boolean renameFile(File from, File to) throws IOException {
        this.ensureHasSpace();
        return this.inner.renameFile(from, to);
    }

    public void runOutOfDiskSpace(boolean outOfSpace) {
        this.outOfSpace = outOfSpace;
    }

    public void ensureHasSpace() throws IOException {
        if (this.outOfSpace) {
            throw new IOException("No space left on device");
        }
    }

    public File[] listFiles(File directory) {
        return this.inner.listFiles(directory);
    }

    public File[] listFiles(File directory, FilenameFilter filter) {
        return this.inner.listFiles(directory, filter);
    }

    public boolean isDirectory(File file) {
        return this.inner.isDirectory(file);
    }

    public void moveToDirectory(File file, File toDirectory) throws IOException {
        this.inner.moveToDirectory(file, toDirectory);
    }

    public void copyFile(File from, File to) throws IOException {
        this.inner.copyFile(from, to);
    }

    public void copyRecursively(File fromDirectory, File toDirectory) throws IOException {
        this.inner.copyRecursively(fromDirectory, toDirectory);
    }

    public <K extends FileSystemAbstraction.ThirdPartyFileSystem> K getOrCreateThirdPartyFileSystem(Class<K> clazz, Function<Class<K>, K> creator) {
        return (K)this.inner.getOrCreateThirdPartyFileSystem(clazz, creator);
    }

    public void truncate(File path, long size) throws IOException {
        this.inner.truncate(path, size);
    }
}

