/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.Page;

public class ByteBufferPage
implements Page {
    protected ByteBuffer buffer;

    public ByteBufferPage(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public byte getByte(int offset) {
        return this.buffer.get(offset);
    }

    public long getLong(int offset) {
        return this.buffer.getLong(offset);
    }

    public void putLong(long value, int offset) {
        this.buffer.putLong(offset, value);
    }

    public int getInt(int offset) {
        return this.buffer.getInt(offset);
    }

    public void putInt(int value, int offset) {
        this.buffer.putInt(offset, value);
    }

    public void getBytes(byte[] data, int offset) {
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.getByte(i + offset);
        }
    }

    public void putBytes(byte[] data, int offset) {
        for (int i = 0; i < data.length; ++i) {
            this.putByte(data[i], offset + i);
        }
    }

    public void putByte(byte value, int offset) {
        this.buffer.put(offset, value);
    }

    public short getShort(int offset) {
        return this.buffer.getShort(offset);
    }

    public void putShort(short value, int offset) {
        this.buffer.putShort(offset, value);
    }

    public int swapIn(StoreChannel channel, long offset, int length) throws IOException {
        int read;
        this.buffer.clear();
        this.buffer.limit(length);
        int bytesRead = 0;
        while ((read = channel.read(this.buffer, offset + (long)bytesRead)) != -1 && (bytesRead += read) < length) {
        }
        while (this.buffer.position() < this.buffer.limit()) {
            this.buffer.put((byte)0);
        }
        return bytesRead;
    }

    public void swapOut(StoreChannel channel, long offset, int length) throws IOException {
        ByteBuffer duplicate = this.buffer.duplicate();
        duplicate.position(0);
        duplicate.limit(length);
        channel.writeAll(duplicate, offset);
    }
}

