/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.Page;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.ByteBufferPage;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.test.ByteArrayMatcher;

public class SingleFilePageSwapperTest {
    private final File file = new File("file");
    private EphemeralFileSystemAbstraction fs;
    private SingleFilePageSwapperFactory factory;

    @Before
    public void setUp() {
        this.fs = new EphemeralFileSystemAbstraction();
        this.factory = new SingleFilePageSwapperFactory((FileSystemAbstraction)this.fs);
    }

    @After
    public void tearDown() {
        this.fs.shutdown();
    }

    @Test
    public void swappingInMustFillPageWithData() throws IOException {
        byte[] bytes = new byte[]{1, 2, 3, 4};
        StoreChannel channel = this.fs.create(this.file);
        channel.writeAll(ByteBuffer.wrap(bytes));
        channel.close();
        PageSwapper swapper = this.factory.createPageSwapper(this.file, 4, null);
        ByteBuffer target = ByteBuffer.allocate(4);
        ByteBufferPage page = new ByteBufferPage(target);
        swapper.read(0L, (Page)page);
        Assert.assertThat((Object)target.array(), (Matcher)ByteArrayMatcher.byteArray(bytes));
    }

    @Test
    public void mustZeroFillPageBeyondEndOfFile() throws IOException {
        byte[] bytes = new byte[]{1, 2, 3, 4, 5, 6};
        StoreChannel channel = this.fs.create(this.file);
        channel.writeAll(ByteBuffer.wrap(bytes));
        channel.close();
        PageSwapper swapper = this.factory.createPageSwapper(this.file, 4, null);
        ByteBuffer target = ByteBuffer.allocate(4);
        ByteBufferPage page = new ByteBufferPage(target);
        swapper.read(1L, (Page)page);
        Assert.assertThat((Object)target.array(), (Matcher)ByteArrayMatcher.byteArray(new byte[]{5, 6, 0, 0}));
    }

    @Test
    public void swappingOutMustWritePageToFile() throws IOException {
        this.fs.create(this.file).close();
        byte[] expected = new byte[]{1, 2, 3, 4};
        ByteBufferPage page = new ByteBufferPage(ByteBuffer.wrap(expected));
        PageSwapper swapper = this.factory.createPageSwapper(this.file, 4, null);
        swapper.write(0L, (Page)page);
        InputStream stream = this.fs.openAsInputStream(this.file);
        byte[] actual = new byte[expected.length];
        stream.read(actual);
        Assert.assertThat((Object)actual, (Matcher)ByteArrayMatcher.byteArray(expected));
    }

    @Test
    public void swappingOutMustNotOverwriteDataBeyondPage() throws IOException {
        byte[] initialData = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        byte[] finalData = new byte[]{1, 2, 3, 4, 8, 7, 6, 5, 9, 10};
        StoreChannel channel = this.fs.create(this.file);
        channel.writeAll(ByteBuffer.wrap(initialData));
        channel.close();
        byte[] change = new byte[]{8, 7, 6, 5};
        ByteBufferPage page = new ByteBufferPage(ByteBuffer.wrap(change));
        PageSwapper swapper = this.factory.createPageSwapper(this.file, 4, null);
        swapper.write(1L, (Page)page);
        InputStream stream = this.fs.openAsInputStream(this.file);
        byte[] actual = new byte[(int)this.fs.getFileSize(this.file)];
        stream.read(actual);
        Assert.assertThat((Object)actual, (Matcher)ByteArrayMatcher.byteArray(finalData));
    }
}

