/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.randomharness;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.randomharness.Record;
import org.neo4j.io.pagecache.randomharness.RecordFormat;

public class PageCountRecordFormat
extends RecordFormat {
    @Override
    public int getRecordSize() {
        return 16;
    }

    @Override
    public Record createRecord(File file, int recordId) {
        return new PageCountRecord(recordId, this.getRecordSize());
    }

    @Override
    public Record readRecord(PageCursor cursor) throws IOException {
        int offset = cursor.getOffset();
        byte[] bytes = new byte[this.getRecordSize()];
        do {
            cursor.setOffset(offset);
            cursor.getBytes(bytes);
        } while (cursor.shouldRetry());
        return new PageCountRecord(bytes);
    }

    @Override
    public Record zeroRecord() {
        return new PageCountRecord(0, this.getRecordSize());
    }

    @Override
    public void write(Record record, PageCursor cursor) {
        PageCountRecord r = (PageCountRecord)record;
        for (int i = 0; i < this.getRecordSize(); ++i) {
            cursor.putByte(r.getRecordId());
        }
    }

    private static final class PageCountRecord
    implements Record {
        private final byte[] bytes;

        public PageCountRecord(int recordId, int recordSize) {
            if (recordId > 127) {
                throw new IllegalArgumentException("Record ID greater than Byte.MAX_VALUE: " + recordId);
            }
            if (recordSize < 1) {
                throw new IllegalArgumentException("Record size must be positive: " + recordSize);
            }
            this.bytes = new byte[recordSize];
            Arrays.fill(this.bytes, (byte)recordId);
        }

        public PageCountRecord(byte[] bytes) {
            if (bytes.length == 0) {
                throw new IllegalArgumentException("Bytes cannot be empty");
            }
            byte first = bytes[0];
            for (byte b : bytes) {
                if (b == first) continue;
                throw new IllegalArgumentException("All bytes must be the same: " + Arrays.toString(bytes));
            }
            this.bytes = bytes;
        }

        public byte getRecordId() {
            return this.bytes[0];
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageCountRecord that = (PageCountRecord)o;
            return Arrays.equals(this.bytes, that.bytes);
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }

        public String toString() {
            return "PageCountRecord[bytes=" + Arrays.toString(this.bytes) + ']';
        }
    }
}

